/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.analyzers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TextNode;
import org.sonar.plugins.html.visitor.DefaultNodeVisitor;
import org.sonar.plugins.html.visitor.HtmlSourceCode;

public class PageCountLines
extends DefaultNodeVisitor {
    private static final Logger LOG = Loggers.get(PageCountLines.class);
    private int blankLines;
    private int headerCommentLines;
    private final Set<Integer> detailedLinesOfCode = new HashSet<Integer>();
    private final Set<Integer> detailedLinesOfComments = new HashSet<Integer>();

    @Override
    public void startDocument(List<Node> nodes) {
        this.blankLines = 0;
        this.headerCommentLines = 0;
        this.detailedLinesOfCode.clear();
        this.detailedLinesOfComments.clear();
        if (this.getHtmlSourceCode().shouldComputeMetric()) {
            this.count(nodes);
        }
    }

    private void addMeasures() {
        HtmlSourceCode htmlSourceCode = this.getHtmlSourceCode();
        htmlSourceCode.addMeasure((Metric<Integer>)CoreMetrics.NCLOC, this.detailedLinesOfCode.size());
        htmlSourceCode.addMeasure((Metric<Integer>)CoreMetrics.COMMENT_LINES, this.detailedLinesOfComments.size());
        htmlSourceCode.setDetailedLinesOfCode(this.detailedLinesOfCode);
        LOG.debug("HtmlSensor: " + this.getHtmlSourceCode().toString() + ": " + this.detailedLinesOfComments.size() + "," + this.headerCommentLines + "," + this.blankLines);
    }

    private void count(List<Node> nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            Node node = nodeList.get(i);
            Node previousNode = i > 0 ? nodeList.get(i - 1) : null;
            Node nextNode = i < nodeList.size() - 1 ? nodeList.get(i + 1) : null;
            this.handleToken(node, previousNode, nextNode);
        }
        this.addMeasures();
    }

    private void handleToken(Node node, @Nullable Node previousNode, @Nullable Node nextNode) {
        int linesOfCodeCurrentNode = node.getLinesOfCode();
        if (nextNode == null) {
            ++linesOfCodeCurrentNode;
        }
        switch (node.getNodeType()) {
            case TAG: 
            case DIRECTIVE: 
            case EXPRESSION: {
                PageCountLines.addLineNumbers(node, this.detailedLinesOfCode);
                break;
            }
            case COMMENT: {
                this.handleTokenComment(node, previousNode, linesOfCodeCurrentNode);
                break;
            }
            case TEXT: {
                this.handleTextToken((TextNode)node, previousNode, linesOfCodeCurrentNode);
                break;
            }
        }
    }

    private void handleTokenComment(Node node, @Nullable Node previousNode, int linesOfCodeCurrentNode) {
        if (previousNode == null) {
            this.headerCommentLines += linesOfCodeCurrentNode;
        } else {
            PageCountLines.addLineNumbers(node, this.detailedLinesOfComments);
        }
    }

    private void handleTextToken(TextNode textNode, @Nullable Node previousNode, int linesOfCodeCurrentNode) {
        this.handleDetailedTextToken(textNode);
        if (textNode.isBlank() && linesOfCodeCurrentNode > 0) {
            int nonBlankLines = 0;
            if (previousNode != null) {
                switch (previousNode.getNodeType()) {
                    case COMMENT: {
                        nonBlankLines = this.handleTextTokenComment(previousNode, nonBlankLines);
                        break;
                    }
                    case TAG: 
                    case DIRECTIVE: 
                    case EXPRESSION: {
                        ++nonBlankLines;
                        break;
                    }
                }
            }
            this.blankLines += linesOfCodeCurrentNode - nonBlankLines;
        }
    }

    private void handleDetailedTextToken(TextNode textNode) {
        String[] element = textNode.getCode().split("\n", -1);
        int startLine = textNode.getStartLinePosition();
        for (int i = 0; i < element.length; ++i) {
            if (StringUtils.isBlank(element[i])) continue;
            this.detailedLinesOfCode.add(startLine + i);
        }
    }

    private int handleTextTokenComment(Node previousNode, int nonBlankLines) {
        if (previousNode.getStartLinePosition() == 1) {
            ++this.headerCommentLines;
        }
        return nonBlankLines + 1;
    }

    private static void addLineNumbers(Node node, Set<Integer> detailedLines) {
        for (int i = node.getStartLinePosition(); i <= node.getEndLinePosition(); ++i) {
            detailedLines.add(i);
        }
    }
}

