/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.code.CodeCharacteristic;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleScope;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RuleDescriptionSection;
import org.sonar.api.server.rule.RuleTagsToTypeConverter;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.internal.DefaultNewParam;
import org.sonar.api.server.rule.internal.DefaultNewRule;
import org.sonar.api.server.rule.internal.DefaultParam;
import org.sonar.api.server.rule.internal.DefaultRepository;

@Immutable
public class DefaultRule
extends RulesDefinition.Rule {
    private final String pluginKey;
    private final RulesDefinition.Repository repository;
    private final String repoKey;
    private final String key;
    private final String name;
    private final RuleType type;
    private final CodeCharacteristic characteristic;
    private final String htmlDescription;
    private final String markdownDescription;
    private final String internalKey;
    private final String severity;
    private final boolean template;
    private final DebtRemediationFunction debtRemediationFunction;
    private final String gapDescription;
    private final Set<String> tags;
    private final Set<String> securityStandards;
    private final Map<String, RulesDefinition.Param> params;
    private final RuleStatus status;
    private final boolean activatedByDefault;
    private final RuleScope scope;
    private final Set<RuleKey> deprecatedRuleKeys;
    private final List<RuleDescriptionSection> ruleDescriptionSections;
    private final Set<String> educationPrincipleKeys;

    DefaultRule(DefaultRepository repository, DefaultNewRule newRule) {
        this.pluginKey = newRule.pluginKey();
        this.repository = repository;
        this.repoKey = newRule.repoKey();
        this.key = newRule.key();
        this.name = newRule.name();
        this.htmlDescription = newRule.htmlDescription();
        this.markdownDescription = newRule.markdownDescription();
        this.internalKey = newRule.internalKey();
        this.severity = newRule.severity();
        this.template = newRule.template();
        this.status = newRule.status();
        this.debtRemediationFunction = newRule.debtRemediationFunction();
        this.gapDescription = newRule.gapDescription();
        this.scope = newRule.scope() == null ? RuleScope.MAIN : newRule.scope();
        this.type = newRule.type() == null ? RuleTagsToTypeConverter.convert(newRule.tags()) : newRule.type();
        this.characteristic = newRule.characteristic();
        TreeSet<String> tagsBuilder = new TreeSet<String>(newRule.tags());
        tagsBuilder.removeAll(RuleTagsToTypeConverter.RESERVED_TAGS);
        this.tags = Collections.unmodifiableSet(tagsBuilder);
        this.securityStandards = Collections.unmodifiableSet(new TreeSet<String>(newRule.securityStandards()));
        HashMap<String, DefaultParam> paramsBuilder = new HashMap<String, DefaultParam>();
        for (RulesDefinition.NewParam newParam : newRule.paramsByKey().values()) {
            paramsBuilder.put(newParam.key(), new DefaultParam((DefaultNewParam)newParam));
        }
        this.params = Collections.unmodifiableMap(paramsBuilder);
        this.activatedByDefault = newRule.activatedByDefault();
        this.deprecatedRuleKeys = Collections.unmodifiableSet(new TreeSet<RuleKey>(newRule.deprecatedRuleKeys()));
        this.ruleDescriptionSections = newRule.getRuleDescriptionSections();
        this.educationPrincipleKeys = Collections.unmodifiableSet(newRule.educationPrincipleKeys());
    }

    @Override
    public RulesDefinition.Repository repository() {
        return this.repository;
    }

    @Override
    @CheckForNull
    public String pluginKey() {
        return this.pluginKey;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public RuleScope scope() {
        return this.scope;
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    @Override
    public CodeCharacteristic characteristic() {
        return this.characteristic;
    }

    @Override
    public String severity() {
        return this.severity;
    }

    @Override
    public List<RuleDescriptionSection> ruleDescriptionSections() {
        return Collections.unmodifiableList(this.ruleDescriptionSections);
    }

    @Override
    public Set<String> educationPrincipleKeys() {
        return this.educationPrincipleKeys;
    }

    @Override
    @CheckForNull
    public String htmlDescription() {
        return this.htmlDescription;
    }

    @Override
    @CheckForNull
    @Deprecated(since="9.6", forRemoval=true)
    public String markdownDescription() {
        return this.markdownDescription;
    }

    @Override
    public boolean template() {
        return this.template;
    }

    @Override
    public boolean activatedByDefault() {
        return this.activatedByDefault;
    }

    @Override
    public RuleStatus status() {
        return this.status;
    }

    @Override
    @CheckForNull
    public DebtRemediationFunction debtRemediationFunction() {
        return this.debtRemediationFunction;
    }

    @Override
    @CheckForNull
    public String gapDescription() {
        return this.gapDescription;
    }

    @Override
    @CheckForNull
    public RulesDefinition.Param param(String key) {
        return this.params.get(key);
    }

    @Override
    public List<RulesDefinition.Param> params() {
        return Collections.unmodifiableList(new ArrayList<RulesDefinition.Param>(this.params.values()));
    }

    @Override
    public Set<String> tags() {
        return this.tags;
    }

    @Override
    public Set<String> securityStandards() {
        return this.securityStandards;
    }

    @Override
    public Set<RuleKey> deprecatedRuleKeys() {
        return this.deprecatedRuleKeys;
    }

    @Override
    @CheckForNull
    public String internalKey() {
        return this.internalKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRule other = (DefaultRule)o;
        return this.key.equals(other.key) && this.repoKey.equals(other.repoKey);
    }

    public int hashCode() {
        int result = this.repoKey.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public String toString() {
        return String.format("[repository=%s, key=%s]", this.repoKey, this.key);
    }
}

