/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;

public final class LogAndArguments {
    private final String rawMsg;
    private final Object[] args;
    private final String msg;

    LogAndArguments(String msg, String rawMsg) {
        this.rawMsg = rawMsg;
        this.msg = msg;
        this.args = null;
    }

    LogAndArguments(String msg, String rawMsg, @Nullable Object arg1) {
        this.rawMsg = rawMsg;
        this.args = new Object[]{arg1};
        this.msg = msg;
    }

    LogAndArguments(String msg, String rawMsg, @Nullable Object arg1, @Nullable Object arg2) {
        this.rawMsg = rawMsg;
        this.msg = msg;
        this.args = new Object[]{arg1, arg2};
    }

    LogAndArguments(String msg, String rawMsg, Object ... args) {
        this.rawMsg = rawMsg;
        this.msg = msg;
        this.args = args;
    }

    public String getRawMsg() {
        return this.rawMsg;
    }

    public Optional<Object[]> getArgs() {
        return Optional.ofNullable(this.args);
    }

    public String getFormattedMsg() {
        return this.msg;
    }

    public String toString() {
        return "LogAndArguments{rawMsg='" + this.rawMsg + "', args=" + Arrays.toString(this.args) + ", msg='" + this.msg + "'}";
    }
}

