/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.internal.apachecommons.lang3.StringUtils;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.FieldUtils2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Cardinality;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

public class RulesDefinitionAnnotationLoader {
    private static final Logger LOG = Loggers.get(RulesDefinitionAnnotationLoader.class);
    private static final Map<Class<?>, RuleParamType> TYPE_FOR_CLASS;

    public void load(RulesDefinition.NewExtendedRepository repo, Class ... annotatedClasses) {
        for (Class annotatedClass : annotatedClasses) {
            this.loadRule(repo, annotatedClass);
        }
    }

    @CheckForNull
    RulesDefinition.NewRule loadRule(RulesDefinition.NewExtendedRepository repo, Class clazz) {
        Rule ruleAnnotation = AnnotationUtils.getAnnotation(clazz, Rule.class);
        if (ruleAnnotation != null) {
            return RulesDefinitionAnnotationLoader.loadRule(repo, clazz, ruleAnnotation);
        }
        LOG.warn("The class " + clazz.getCanonicalName() + " should be annotated with " + String.valueOf(Rule.class));
        return null;
    }

    private static RulesDefinition.NewRule loadRule(RulesDefinition.NewExtendedRepository repo, Class clazz, Rule ruleAnnotation) {
        String ruleKey = StringUtils.defaultIfEmpty(ruleAnnotation.key(), clazz.getCanonicalName());
        String ruleName = StringUtils.defaultIfEmpty(ruleAnnotation.name(), null);
        String description = StringUtils.defaultIfEmpty(ruleAnnotation.description(), null);
        RulesDefinition.NewRule rule = repo.createRule(ruleKey);
        rule.setName(ruleName).setHtmlDescription(description);
        rule.setSeverity(ruleAnnotation.priority().name());
        rule.setTemplate(ruleAnnotation.cardinality() == Cardinality.MULTIPLE);
        rule.setStatus(RuleStatus.valueOf(ruleAnnotation.status()));
        rule.setTags(ruleAnnotation.tags());
        List<Field> fields = FieldUtils2.getFields(clazz, true);
        for (Field field : fields) {
            RulesDefinitionAnnotationLoader.loadParameters(rule, field);
        }
        return rule;
    }

    private static void loadParameters(RulesDefinition.NewRule rule, Field field) {
        RuleProperty propertyAnnotation = field.getAnnotation(RuleProperty.class);
        if (propertyAnnotation != null) {
            String fieldKey = StringUtils.defaultIfEmpty(propertyAnnotation.key(), field.getName());
            RulesDefinition.NewParam param = rule.createParam(fieldKey).setDescription(propertyAnnotation.description()).setDefaultValue(propertyAnnotation.defaultValue());
            if (!StringUtils.isBlank(propertyAnnotation.type())) {
                try {
                    param.setType(RuleParamType.parse(propertyAnnotation.type().trim()));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid property type [" + propertyAnnotation.type() + "]", e);
                }
            } else {
                param.setType(RulesDefinitionAnnotationLoader.guessType(field.getType()));
            }
        }
    }

    static RuleParamType guessType(Class<?> type) {
        RuleParamType result = TYPE_FOR_CLASS.get(type);
        return result != null ? result : RuleParamType.STRING;
    }

    static {
        HashMap<Class<Serializable>, RuleParamType> map = new HashMap<Class<Serializable>, RuleParamType>();
        map.put(Integer.class, RuleParamType.INTEGER);
        map.put(Integer.TYPE, RuleParamType.INTEGER);
        map.put(Float.class, RuleParamType.FLOAT);
        map.put(Float.TYPE, RuleParamType.FLOAT);
        map.put(Boolean.class, RuleParamType.BOOLEAN);
        map.put(Boolean.TYPE, RuleParamType.BOOLEAN);
        TYPE_FOR_CLASS = Collections.unmodifiableMap(map);
    }
}

