/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.checks.verifier.MultiFileVerifier;
import org.sonarsource.analyzer.commons.checks.verifier.SingleFileVerifier;
import org.sonarsource.analyzer.commons.checks.verifier.internal.IssueLocation;

class InternalIssue
implements SingleFileVerifier.IssueBuilder,
MultiFileVerifier.IssueBuilder,
SingleFileVerifier.Issue,
MultiFileVerifier.Issue {
    private final Path path;
    final String message;
    IssueLocation location;
    List<Secondary> secondaries = new ArrayList<Secondary>();
    List<List<Secondary>> flows = new ArrayList<List<Secondary>>();
    @Nullable
    Double gap = null;

    public InternalIssue(Path path, String message) {
        this.path = path;
        this.message = message;
    }

    @Override
    public InternalIssue onFile() {
        this.location = new IssueLocation.File(this.path);
        return this;
    }

    @Override
    public InternalIssue onLine(int line) {
        this.location = new IssueLocation.Line(this.path, line);
        return this;
    }

    @Override
    public InternalIssue onRange(int line, int column, int endLine, int endColumn) {
        this.location = new IssueLocation.Range(this.path, line, column, endLine, endColumn);
        return this;
    }

    @Override
    public InternalIssue withGap(@Nullable Double gap) {
        this.gap = gap;
        return this;
    }

    @Override
    public InternalIssue addSecondary(int line, int column, int endLine, int endColumn, @Nullable String message) {
        return this.addSecondary(this.path, line, column, endLine, endColumn, message);
    }

    @Override
    public InternalIssue addSecondary(Path secondaryPath, int line, int column, int endLine, int endColumn, @Nullable String message) {
        this.secondaries.add(new Secondary(new IssueLocation.Range(secondaryPath, line, column, endLine, endColumn), message));
        return this;
    }

    public InternalIssue addFlow(int line, int column, int endLine, int endColumn, int flowIndex, @Nullable String message) {
        return this.addFlow(this.path, line, column, endLine, endColumn, flowIndex, message);
    }

    public InternalIssue addFlow(Path flowPath, int line, int column, int endLine, int endColumn, int flowIndex, @Nullable String message) {
        int flowOffset = flowIndex - 1;
        while (flowOffset >= this.flows.size()) {
            this.flows.add(new ArrayList());
        }
        this.flows.get(flowOffset).add(new Secondary(new IssueLocation.Range(flowPath, line, column, endLine, endColumn), message));
        return this;
    }

    public static class Secondary {
        public final IssueLocation.Range range;
        @Nullable
        public final String message;

        public Secondary(IssueLocation.Range range, @Nullable String message) {
            this.range = range;
            this.message = message;
        }
    }
}

