/*
 * Decompiled with CFR 0.152.
 */
package com.sonarsource.checks.verifier.internal;

import com.sonarsource.checks.verifier.internal.FlowLocation;
import com.sonarsource.checks.verifier.internal.NoncompliantCommentParser;
import com.sonarsource.checks.verifier.internal.PreciseLocation;
import com.sonarsource.checks.verifier.internal.PrimaryLocation;
import com.sonarsource.checks.verifier.internal.SecondaryLocation;
import com.sonarsource.checks.verifier.internal.UnderlinedRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PreciseLocationParser {
    private static final Pattern TRIGGER = Pattern.compile("^ *+\\^");
    public static final String LINE_ADJUSTMENT = "(?:@(?<lineAdjustment>(?<relativeAdjustment>[+-])?\\d++))?";
    private static final Pattern LOCATION_REGEX = Pattern.compile(" *+(?<range>\\^(?:\\[(?<params>[^\\]]++)\\]|\\^++)?)(?:@(?<lineAdjustment>(?<relativeAdjustment>[+-])?\\d++))? *+(?:(?<count>\\d++)|(?:(?<direction><|>) *+((?<majorIndex>\\d++)(\\.(?<minorIndex>\\d++))?)?))? *+(?:\\{\\{(?<message>.*?)\\}\\})? *+(?:\r(\n?)|\n)?");

    private PreciseLocationParser() {
    }

    public static List<PreciseLocation> parse(int line, int column, String commentContent) {
        if (TRIGGER.matcher(commentContent).lookingAt()) {
            ArrayList<PreciseLocation> result = new ArrayList<PreciseLocation>();
            Matcher matcher = LOCATION_REGEX.matcher(commentContent);
            matcher.region(0, commentContent.length());
            while (matcher.lookingAt()) {
                result.add(PreciseLocationParser.matcherToLocation(line, column, matcher));
                matcher.region(matcher.end(), commentContent.length());
            }
            if (matcher.regionStart() != commentContent.length()) {
                String position = "line " + line + " col " + (column + matcher.regionStart());
                throw new IllegalStateException("Precise Location: unexpected character found at " + position + " in: " + commentContent);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static PreciseLocation matcherToLocation(int line, int column, Matcher matcher) {
        int effectiveLine = PreciseLocationParser.extractEffectiveLine(line - 1, matcher);
        UnderlinedRange range = PreciseLocationParser.fileRange(effectiveLine, column, matcher);
        String direction = matcher.group("direction");
        String minorIndexGroup = matcher.group("minorIndex");
        if (direction == null) {
            String countGroup = matcher.group("count");
            Integer additionalCount = countGroup == null ? null : Integer.valueOf(countGroup);
            return new PrimaryLocation(range, additionalCount);
        }
        if (minorIndexGroup == null) {
            String majorIndex = matcher.group("majorIndex");
            Integer index = majorIndex == null ? null : Integer.valueOf(majorIndex);
            return new SecondaryLocation(range, direction.equals("<"), index, matcher.group("message"));
        }
        int majorIndex = Integer.parseInt(matcher.group("majorIndex"));
        int minorIndex = Integer.parseInt(minorIndexGroup);
        return new FlowLocation(range, direction.equals("<"), majorIndex, minorIndex, matcher.group("message"));
    }

    public static int extractEffectiveLine(int line, Matcher matcher) {
        String lineAdjustmentGroup = matcher.group("lineAdjustment");
        String relativeAdjustmentGroup = matcher.group("relativeAdjustment");
        int referenceLine = relativeAdjustmentGroup != null ? line : 0;
        return lineAdjustmentGroup == null ? line : referenceLine + Integer.parseInt(lineAdjustmentGroup);
    }

    private static UnderlinedRange fileRange(int line, int column, Matcher matcher) {
        int rangeLine = line;
        int rangeColumn = column + matcher.start("range");
        int rangeEndLine = line;
        int rangeEndColumn = column + matcher.end("range") - 1;
        String params = matcher.group("params");
        if (params != null) {
            rangeEndColumn = rangeColumn;
            Map<String, String> paramMap = NoncompliantCommentParser.extractParams(params);
            rangeLine = PreciseLocationParser.consumePropertyAndAdjustValue(rangeLine, paramMap, "sl");
            rangeColumn = PreciseLocationParser.consumePropertyAndAdjustValue(rangeColumn, paramMap, "sc");
            rangeEndColumn = PreciseLocationParser.consumePropertyAndAdjustValue(rangeEndColumn, paramMap, "ec");
            rangeEndLine = PreciseLocationParser.consumePropertyAndAdjustValue(rangeEndLine, paramMap, "el");
            if (!paramMap.isEmpty()) {
                throw new IllegalStateException("Unknown attributes at line " + line + " in: " + params);
            }
        }
        return new UnderlinedRange(rangeLine, rangeColumn, rangeEndLine, rangeEndColumn);
    }

    private static int consumePropertyAndAdjustValue(int referenceValue, Map<String, String> paramMap, String propertyName) {
        String shift = paramMap.remove(propertyName);
        if (shift == null) {
            return referenceValue;
        }
        if (shift.startsWith("-") || shift.startsWith("+")) {
            return referenceValue + Integer.parseInt(shift.substring(1));
        }
        return Integer.parseInt(shift);
    }
}

