/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.collections;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sonarsource.analyzer.commons.collections.AVLTree;

class TreeIterator<K, V>
implements Iterator<AVLTree<K, V>> {
    private final Deque<AVLTree<K, V>> stack = new ArrayDeque<AVLTree<K, V>>();
    private AVLTree<K, V> current;

    TreeIterator(AVLTree<K, V> root) {
        this.current = root;
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty() || !this.current.isEmpty();
    }

    @Override
    public AVLTree<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        while (!this.current.isEmpty()) {
            this.stack.push(this.current);
            this.current = this.current.left();
        }
        AVLTree<K, V> node = this.current = this.stack.pop();
        this.current = this.current.right();
        return node;
    }
}

