/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.utils.WildcardPattern;

public class FileProvider {
    private final Path baseDir;
    private final WildcardPattern pattern;

    public FileProvider(File baseDir, String pattern) {
        this.baseDir = baseDir.toPath();
        this.pattern = WildcardPattern.create((String)pattern);
    }

    public List<File> getMatchingFiles() {
        List<File> list;
        block8: {
            Stream<Path> walk = Files.walk(this.baseDir, new FileVisitOption[0]);
            try {
                list = walk.filter(p -> !Files.isDirectory(p, new LinkOption[0]) && this.pattern.match(FileProvider.toUnixString(this.baseDir.relativize((Path)p)))).map(Path::toFile).collect(Collectors.toList());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to get matching files.", e);
                }
            }
            walk.close();
        }
        return list;
    }

    private static String toUnixString(Path path) {
        return path.toString().replace('\\', '/');
    }
}

