/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.sonarsource.analyzer.commons.JsonParser;

public class ProfileGenerator {
    private static final JsonParser jsonParser = new JsonParser();
    private static final int QUERY_PAGE_SIZE = 500;

    private ProfileGenerator() {
    }

    public static File generateProfile(String serverUrl, String language, String repository, RulesConfiguration rulesConfiguration, Set<String> excludedRules) {
        try {
            Set<String> ruleKeys = ProfileGenerator.getRuleKeys(serverUrl, language, repository);
            ruleKeys.removeAll(excludedRules);
            return ProfileGenerator.generateProfile(language, repository, rulesConfiguration, ruleKeys);
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    static File generateProfile(String language, String repository, RulesConfiguration rulesConfiguration, Set<String> ruleKeys) throws XMLStreamException, IOException {
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        StringWriter stringWriter = new StringWriter();
        XMLStreamWriter xml = output.createXMLStreamWriter(stringWriter);
        xml.writeStartDocument();
        xml.writeStartElement("profile");
        ProfileGenerator.el(xml, "name", "rules");
        ProfileGenerator.el(xml, "language", language);
        xml.writeStartElement("rules");
        for (String key : ruleKeys) {
            xml.writeStartElement("rule");
            ProfileGenerator.el(xml, "repositoryKey", repository);
            ProfileGenerator.el(xml, "key", key);
            ProfileGenerator.el(xml, "priority", "INFO");
            Collection parameters = rulesConfiguration.config.getOrDefault(key, Collections.emptyList());
            if (!parameters.isEmpty()) {
                xml.writeStartElement("parameters");
                for (Parameter parameter : parameters) {
                    xml.writeStartElement("parameter");
                    ProfileGenerator.el(xml, "key", parameter.parameterKey);
                    ProfileGenerator.el(xml, "value", parameter.parameterValue);
                    xml.writeEndElement();
                }
                xml.writeEndElement();
            }
            xml.writeEndElement();
        }
        xml.writeEndElement();
        xml.writeEndElement();
        xml.writeEndDocument();
        File file = File.createTempFile("profile", ".xml");
        Files.write(file.toPath(), stringWriter.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        file.deleteOnExit();
        return file;
    }

    private static void el(XMLStreamWriter xml, String name, String text) throws XMLStreamException {
        xml.writeStartElement(name);
        xml.writeCharacters(text);
        xml.writeEndElement();
    }

    private static Set<String> getRuleKeys(String serverUrl, String language, String repository) throws IOException {
        int total;
        HashSet<String> ruleKeys = new HashSet<String>();
        int processed = 0;
        int page = 1;
        do {
            Map response = ProfileGenerator.queryRules(serverUrl, language, repository, page);
            total = (Integer)response.get("total");
            Map jsonRules = (Map)response.get("rules");
            for (Map jsonRule : jsonRules.values()) {
                String key = ((String)jsonRule.get("key")).split(":")[1];
                ruleKeys.add(key);
                ++processed;
            }
            ++page;
        } while (processed < total);
        return ruleKeys;
    }

    private static Map queryRules(String serverUrl, String language, String repository, int page) throws IOException {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("languages", language);
        queryParams.put("repositories", repository);
        queryParams.put("ps", 500);
        queryParams.put("p", page);
        String params = queryParams.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining("&"));
        URL url = new URL(serverUrl + "/api/rules/search?" + params);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.connect();
        String response = new BufferedReader(new InputStreamReader(con.getInputStream())).lines().collect(Collectors.joining("\n"));
        con.disconnect();
        return jsonParser.parse(response);
    }

    private static class Parameter {
        String parameterKey;
        String parameterValue;

        Parameter(String parameterKey, String parameterValue) {
            this.parameterKey = parameterKey;
            this.parameterValue = parameterValue;
        }
    }

    public static class RulesConfiguration {
        private Map<String, List<Parameter>> config = new HashMap<String, List<Parameter>>();

        public RulesConfiguration add(String ruleKey, String parameterKey, String parameterValue) {
            List ruleConfiguration = this.config.computeIfAbsent(ruleKey, k -> new ArrayList());
            ruleConfiguration.add(new Parameter(parameterKey, parameterValue));
            return this;
        }
    }
}

