/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.Billing;
import org.solovyev.android.checkout.Cache;

final class SafeCache
implements Cache {
    @Nonnull
    private final Cache mCache;

    SafeCache(@Nonnull Cache cache) {
        this.mCache = cache;
    }

    @Override
    @Nullable
    public Cache.Entry get(@Nonnull Cache.Key key) {
        try {
            return this.mCache.get(key);
        }
        catch (Exception e) {
            Billing.error(e);
            return null;
        }
    }

    @Override
    public void put(@Nonnull Cache.Key key, @Nonnull Cache.Entry entry) {
        try {
            this.mCache.put(key, entry);
        }
        catch (Exception e) {
            Billing.error(e);
        }
    }

    @Override
    public void init() {
        try {
            this.mCache.init();
        }
        catch (Exception e) {
            Billing.error(e);
        }
    }

    @Override
    public void remove(@Nonnull Cache.Key key) {
        try {
            this.mCache.remove(key);
        }
        catch (Exception e) {
            Billing.error(e);
        }
    }

    @Override
    public void removeAll(int type) {
        try {
            this.mCache.removeAll(type);
        }
        catch (Exception e) {
            Billing.error(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.mCache.clear();
        }
        catch (Exception e) {
            Billing.error(e);
        }
    }
}

