/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.MainThread;

final class Check {
    private static final boolean sJunit = Check.isJunit();

    private Check() {
        throw new AssertionError();
    }

    private static boolean isJunit() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    static void isMainThread() {
        if (!sJunit && !MainThread.isMainThread()) {
            throw new AssertionException("Should be called on the main thread");
        }
    }

    static void isNotNull(@Nullable Object o) {
        Check.isNotNull(o, "Object should not be null");
    }

    static void isNotNull(@Nullable Object o, @Nonnull String message) {
        if (o == null) {
            throw new AssertionException(message);
        }
    }

    static void notEquals(int expected, int actual) {
        if (expected == actual) {
            throw new AssertionException("Should not be equal");
        }
    }

    static void equals(int expected, int actual) {
        if (expected != actual) {
            throw new AssertionException("Should be equal");
        }
    }

    static void equals(@Nullable Object expected, @Nullable Object actual) {
        Check.equals(expected, actual, "Should be equal");
    }

    static void equals(@Nullable Object expected, @Nullable Object actual, @Nonnull String message) {
        if (expected == actual) {
            return;
        }
        if (expected != null && actual != null && expected.equals(actual)) {
            return;
        }
        throw new AssertionException(message);
    }

    static void isTrue(boolean expression, @Nonnull String message) {
        if (!expression) {
            throw new AssertionException(message);
        }
    }

    static void isFalse(boolean expression, @Nonnull String message) {
        if (expression) {
            throw new AssertionException(message);
        }
    }

    static void isNull(@Nullable Object o) {
        Check.isNull(o, "Object should be null");
    }

    static void isNull(@Nullable Object o, @Nonnull String message) {
        if (o != null) {
            throw new AssertionException(message);
        }
    }

    static void isNotEmpty(@Nullable String s) {
        if (s == null || s.length() == 0) {
            throw new AssertionException("String should not be empty");
        }
    }

    static void isNotEmpty(@Nullable Collection<?> c) {
        if (c == null || c.size() == 0) {
            throw new AssertionException("Collection should not be empty");
        }
    }

    static void same(Object expected, Object actual) {
        if (expected != actual) {
            throw new AssertionException("Objects should be the same");
        }
    }

    private static final class AssertionException
    extends RuntimeException {
        private AssertionException(@Nonnull String message) {
            super(message);
        }
    }
}

