/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.os.Handler;
import android.os.Looper;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.solovyev.android.checkout.MainThread;
import org.solovyev.android.checkout.Purchase;
import org.solovyev.android.checkout.PurchaseVerifier;
import org.solovyev.android.checkout.RequestListener;

public abstract class BasePurchaseVerifier
implements PurchaseVerifier {
    @Nonnull
    private final Executor mBackground;
    @Nonnull
    private final MainThread mMainThread;

    protected BasePurchaseVerifier() {
        this(new Handler(Looper.getMainLooper()));
    }

    protected BasePurchaseVerifier(@Nonnull Handler handler) {
        this(handler, 2, BasePurchaseVerifier.defaultThreadFactory());
    }

    protected BasePurchaseVerifier(@Nonnull Handler handler, int threadCount, @Nonnull ThreadFactory threadFactory) {
        this.mMainThread = new MainThread(handler);
        this.mBackground = Executors.newFixedThreadPool(threadCount, threadFactory);
    }

    @Nonnull
    private static ThreadFactory defaultThreadFactory() {
        return new ThreadFactory(){
            @Nonnull
            private final AtomicInteger mCount = new AtomicInteger();

            @Override
            public Thread newThread(@Nonnull Runnable r) {
                return new Thread(r, "PurchaseVerifierThread #" + this.mCount.getAndIncrement());
            }
        };
    }

    @Override
    public final void verify(final @Nonnull List<Purchase> purchases, final @Nonnull RequestListener<List<Purchase>> listener) {
        if (MainThread.isMainThread()) {
            this.mBackground.execute(new Runnable(){

                @Override
                public void run() {
                    BasePurchaseVerifier.this.doVerify(purchases, new MainThreadRequestListener(listener));
                }
            });
        } else {
            this.doVerify(purchases, listener);
        }
    }

    protected abstract void doVerify(@Nonnull List<Purchase> var1, @Nonnull RequestListener<List<Purchase>> var2);

    private final class MainThreadRequestListener
    implements RequestListener<List<Purchase>> {
        @Nonnull
        private final RequestListener<List<Purchase>> mListener;

        private MainThreadRequestListener(RequestListener<List<Purchase>> listener) {
            this.mListener = listener;
        }

        @Override
        public void onSuccess(final @Nonnull List<Purchase> result) {
            BasePurchaseVerifier.this.mMainThread.execute(new Runnable(){

                @Override
                public void run() {
                    MainThreadRequestListener.this.mListener.onSuccess(result);
                }
            });
        }

        @Override
        public void onError(final int response, final @Nonnull Exception e) {
            BasePurchaseVerifier.this.mMainThread.execute(new Runnable(){

                @Override
                public void run() {
                    MainThreadRequestListener.this.mListener.onError(response, e);
                }
            });
        }
    }
}

