/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.wizard;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.wizard.Wizard;
import org.solovyev.android.wizard.WizardFlow;
import org.solovyev.android.wizard.WizardStep;

public class BaseWizard
implements Wizard {
    static final String FLOW = "flow";
    static final String FLOW_FINISHED = "flow_finished";
    @Nonnull
    private final String name;
    @Nonnull
    private final Context context;
    @Nonnull
    private final WizardFlow flow;

    public BaseWizard(@Nonnull String name, @Nonnull Context context, @Nonnull WizardFlow flow) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/BaseWizard.<init> must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/wizard/BaseWizard.<init> must not be null");
        }
        if (flow == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/wizard/BaseWizard.<init> must not be null");
        }
        this.name = name;
        this.context = context;
        this.flow = flow;
    }

    public void saveLastStep(@Nonnull WizardStep step) {
        if (step == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/BaseWizard.saveLastStep must not be null");
        }
        SharedPreferences preferences = this.getPreferences();
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(BaseWizard.makeLastStepPreferenceKey(this.name), step.getName());
        editor.commit();
    }

    public void saveFinished(@Nonnull WizardStep step, boolean forceFinish) {
        if (step == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/BaseWizard.saveFinished must not be null");
        }
        SharedPreferences preferences = this.getPreferences();
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(BaseWizard.makeFinishedPreferenceKey(this.name), forceFinish || this.flow.getNextStep(step) == null);
        editor.commit();
    }

    @Nonnull
    private SharedPreferences getPreferences() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        if (sharedPreferences == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/wizard/BaseWizard.getPreferences must not return null");
        }
        return sharedPreferences;
    }

    @Nullable
    public String getLastSavedStepName() {
        return this.getPreferences().getString(BaseWizard.makeLastStepPreferenceKey(this.name), null);
    }

    public boolean isFinished() {
        return this.getPreferences().getBoolean(BaseWizard.makeFinishedPreferenceKey(this.name), false);
    }

    public boolean isStarted() {
        return this.getLastSavedStepName() != null;
    }

    @Nonnull
    static String makeFinishedPreferenceKey(@Nonnull String flowName) {
        if (flowName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/BaseWizard.makeFinishedPreferenceKey must not be null");
        }
        String string2 = "flow_finished:" + flowName;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/wizard/BaseWizard.makeFinishedPreferenceKey must not return null");
        }
        return string2;
    }

    @Nonnull
    static String makeLastStepPreferenceKey(@Nonnull String flowName) {
        if (flowName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/wizard/BaseWizard.makeLastStepPreferenceKey must not be null");
        }
        String string2 = "flow:" + flowName;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/wizard/BaseWizard.makeLastStepPreferenceKey must not return null");
        }
        return string2;
    }

    @Nonnull
    public WizardFlow getFlow() {
        WizardFlow wizardFlow = this.flow;
        if (wizardFlow == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/wizard/BaseWizard.getFlow must not return null");
        }
        return wizardFlow;
    }

    @Nonnull
    public String getName() {
        String string2 = this.name;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/wizard/BaseWizard.getName must not return null");
        }
        return string2;
    }
}

