/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view.sidebar;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.sidebar.OnSlideListener;
import org.solovyev.android.view.sidebar.SideBarAttributes;

final class SideBarSlider {
    private static final int MAX_OFFSET_DIFF = 150;
    @Nonnull
    private final Animation.AnimationListener openListener;
    @Nonnull
    private final Animation.AnimationListener closeListener;
    private int offset;
    private int closedOffset;
    private int openedOffset;
    private boolean opening;
    @Nonnull
    private View sideBarLayout;
    private final SideBarAttributes attributes;
    @Nullable
    private final OnSlideListener onSlideListener;

    SideBarSlider(@Nonnull View sideBarLayout, SideBarAttributes attributes, @Nullable OnSlideListener onSlideListener) {
        if (sideBarLayout == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/sidebar/SideBarSlider.<init> must not be null");
        }
        this.openListener = new SlidingViewOpenListener();
        this.closeListener = new SlidingViewCloseListener();
        this.sideBarLayout = sideBarLayout;
        this.offset = attributes.getSlidingViewLedge();
        this.closedOffset = attributes.getSlidingViewLedge();
        this.openedOffset = attributes.getSlidingViewLedge();
        this.opening = true;
        this.attributes = attributes;
        this.onSlideListener = onSlideListener;
    }

    public void init(int closedOffset, int openedOffset, boolean opening) {
        this.offset = opening ? closedOffset : openedOffset;
        this.closedOffset = closedOffset;
        this.openedOffset = openedOffset;
        this.opening = opening;
    }

    public int getOffsetOnScreen() {
        int result;
        switch (this.attributes.getSlidingViewPosition()) {
            case left: 
            case top: {
                result = this.offset;
                break;
            }
            case right: {
                result = this.sideBarLayout.getMeasuredWidth() - this.offset;
                break;
            }
            case bottom: {
                result = this.sideBarLayout.getMeasuredHeight() - this.offset;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    public void completeOpening() {
        this.offset = this.openedOffset;
    }

    public void completeClosing() {
        this.offset = this.closedOffset;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isOpening() {
        return this.opening;
    }

    @Nonnull
    public Animation newCloseAnimation() {
        this.offset = Math.max(this.offset, this.closedOffset);
        SlideAnimation animation = new SlideAnimation(this.offset, this.closedOffset);
        animation.setAnimationListener(this.closeListener);
        SlideAnimation slideAnimation = animation;
        if (slideAnimation == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/sidebar/SideBarSlider.newCloseAnimation must not return null");
        }
        return slideAnimation;
    }

    @Nonnull
    public Animation newOpenAnimation() {
        this.offset = Math.min(this.offset, this.openedOffset);
        SlideAnimation animation = new SlideAnimation(this.offset, this.openedOffset);
        animation.setAnimationListener(this.openListener);
        SlideAnimation slideAnimation = animation;
        if (slideAnimation == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/sidebar/SideBarSlider.newOpenAnimation must not return null");
        }
        return slideAnimation;
    }

    public void addOffsetDelta(int delta) {
        switch (this.attributes.getSlidingViewPosition()) {
            case left: 
            case top: {
                this.offset += delta;
                break;
            }
            case right: 
            case bottom: {
                this.offset -= delta;
            }
        }
        boolean canFinishSlide = this.offset <= this.closedOffset || this.offset >= this.openedOffset;
        this.offset = Math.min(this.offset, this.openedOffset);
        this.offset = Math.max(this.offset, this.closedOffset);
        if (canFinishSlide) {
            this.finishSlide();
        }
    }

    public void finishSlide() {
        int twoThirds;
        int third;
        boolean proceedOpening = this.isOpening() ? this.offset > (third = Math.abs(this.openedOffset + 2 * this.closedOffset) / 3) : this.offset > (twoThirds = Math.abs(2 * this.openedOffset + this.closedOffset) / 3);
        this.sideBarLayout.startAnimation(proceedOpening ? this.newOpenAnimation() : this.newCloseAnimation());
    }

    public String toString() {
        return "SideBarViewOffsets{offset=" + this.offset + ", closedOffset=" + this.closedOffset + ", openedOffset=" + this.openedOffset + ", opening=" + this.opening + '}';
    }

    public boolean canStartSlide(float z) {
        boolean result;
        switch (this.attributes.getSlidingViewPosition()) {
            case left: 
            case top: {
                result = z < (float)(this.getOffsetOnScreen() + 150);
                break;
            }
            case right: 
            case bottom: {
                result = z > (float)(this.getOffsetOnScreen() - 150);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    private class SlidingViewCloseListener
    implements Animation.AnimationListener {
        private SlidingViewCloseListener() {
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            SideBarSlider.this.completeClosing();
            SideBarSlider.this.onSlideListener.onSlideCompleted(false);
        }
    }

    private class SlidingViewOpenListener
    implements Animation.AnimationListener {
        private SlidingViewOpenListener() {
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            SideBarSlider.this.completeOpening();
            SideBarSlider.this.onSlideListener.onSlideCompleted(true);
        }
    }

    class SlideAnimation
    extends Animation {
        private static final float SPEED = 0.6f;
        private float mStart;
        private float mEnd;

        public SlideAnimation(float fromX, float toX) {
            this.mStart = fromX;
            this.mEnd = toX;
            this.setInterpolator((Interpolator)new DecelerateInterpolator());
            float duration = Math.abs(this.mEnd - this.mStart) / 0.6f;
            this.setDuration((long)duration);
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            super.applyTransformation(interpolatedTime, t);
            float offset = (this.mEnd - this.mStart) * interpolatedTime + this.mStart;
            SideBarSlider.this.offset = (int)offset;
            SideBarSlider.this.sideBarLayout.postInvalidate();
        }
    }
}

