/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view.sidebar;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import javax.annotation.Nonnull;
import org.solovyev.android.view.R;
import org.solovyev.android.view.sidebar.SideBarSlidingViewPosition;
import org.solovyev.android.view.sidebar.SideBarSlidingViewStyle;

final class SideBarAttributes {
    private int slidingViewLedge = 0;
    private int mainViewId = -1;
    private int slidingViewId = -1;
    private boolean slideMainView = false;
    @Nonnull
    private SideBarSlidingViewPosition slidingViewPosition = SideBarSlidingViewPosition.left;
    @Nonnull
    private SideBarSlidingViewStyle slidingViewStyle = SideBarSlidingViewStyle.push;

    private SideBarAttributes() {
    }

    @Nonnull
    public static SideBarAttributes newAttributes(@Nonnull Context context, @Nonnull AttributeSet attrs) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/sidebar/SideBarAttributes.newAttributes must not be null");
        }
        if (attrs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/sidebar/SideBarAttributes.newAttributes must not be null");
        }
        SideBarAttributes result = new SideBarAttributes();
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.SideBarLayout);
        result.mainViewId = attributes.getResourceId(R.styleable.SideBarLayout_mainViewId, -1);
        result.slidingViewId = attributes.getResourceId(R.styleable.SideBarLayout_slidingViewId, -1);
        result.slidingViewLedge = attributes.getDimensionPixelSize(R.styleable.SideBarLayout_slidingViewLedge, 0);
        result.slidingViewPosition = SideBarSlidingViewPosition.getById(attributes.getInt(R.styleable.SideBarLayout_slidingViewPosition, 0));
        result.slidingViewStyle = SideBarSlidingViewStyle.getById(attributes.getInt(R.styleable.SideBarLayout_slidingViewStyle, 0));
        attributes.recycle();
        SideBarAttributes.checkAttributes(result);
        SideBarAttributes sideBarAttributes = result;
        if (sideBarAttributes == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/sidebar/SideBarAttributes.newAttributes must not return null");
        }
        return sideBarAttributes;
    }

    private static void checkAttributes(SideBarAttributes result) {
        if (result.mainViewId == -1) {
            throw new IllegalArgumentException("Main view id must be set!");
        }
        if (result.slidingViewId == -1) {
            throw new IllegalArgumentException("Sliding view id must be set!");
        }
    }

    @Nonnull
    public static SideBarAttributes newAttributes(int mainViewId, int slidingViewId, int slidingViewLedge, SideBarSlidingViewPosition slidingViewPosition) {
        SideBarAttributes result = new SideBarAttributes();
        result.mainViewId = mainViewId;
        result.slidingViewId = slidingViewId;
        result.slidingViewLedge = slidingViewLedge;
        result.slidingViewPosition = slidingViewPosition;
        SideBarAttributes.checkAttributes(result);
        SideBarAttributes sideBarAttributes = result;
        if (sideBarAttributes == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/sidebar/SideBarAttributes.newAttributes must not return null");
        }
        return sideBarAttributes;
    }

    public int getSlidingViewLedge() {
        return this.slidingViewLedge;
    }

    public int getMainViewId() {
        return this.mainViewId;
    }

    public int getSlidingViewId() {
        return this.slidingViewId;
    }

    public boolean isSlideMainView() {
        return this.slideMainView;
    }

    public SideBarSlidingViewPosition getSlidingViewPosition() {
        return this.slidingViewPosition;
    }

    public boolean isSlidingViewLedgeExists() {
        return this.slidingViewLedge > 0;
    }

    public SideBarSlidingViewStyle getSlidingViewStyle() {
        return this.slidingViewStyle;
    }
}

