/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view.drag;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import android.view.MotionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.R;
import org.solovyev.android.view.drag.DragButton;
import org.solovyev.android.view.drag.DragDirection;
import org.solovyev.android.view.drag.DragEvent;
import org.solovyev.android.view.drag.DragPreferencesChangeListener;
import org.solovyev.android.view.drag.OnDragListener;
import org.solovyev.common.MutableObject;
import org.solovyev.common.interval.Interval;
import org.solovyev.common.interval.Intervals;
import org.solovyev.common.math.Maths;
import org.solovyev.common.math.Point2d;
import org.solovyev.common.text.NumberIntervalMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleOnDragListener
implements OnDragListener,
DragPreferencesChangeListener {
    @Nonnull
    public static final Point2d axis = new Point2d(0.0f, 1.0f);
    @Nonnull
    private DragProcessor dragProcessor;
    @Nonnull
    private Preferences preferences;

    public SimpleOnDragListener(@Nonnull Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.<init> must not be null");
        }
        this.preferences = preferences;
    }

    public SimpleOnDragListener(@Nonnull DragProcessor dragProcessor, @Nonnull Preferences preferences) {
        if (dragProcessor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.<init> must not be null");
        }
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.<init> must not be null");
        }
        this.dragProcessor = dragProcessor;
        this.preferences = preferences;
    }

    @Override
    public boolean onDrag(@Nonnull DragButton dragButton, @Nonnull DragEvent event) {
        if (dragButton == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.onDrag must not be null");
        }
        if (event == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.onDrag must not be null");
        }
        boolean result = false;
        this.logDragEvent(dragButton, event);
        Point2d startPoint = event.getStartPoint();
        MotionEvent motionEvent = event.getMotionEvent();
        Point2d endPoint = new Point2d(motionEvent.getX(), motionEvent.getY());
        float distance = Maths.getDistance((Point2d)startPoint, (Point2d)endPoint);
        MutableObject right = new MutableObject();
        double angle = Math.toDegrees(Maths.getAngle((Point2d)startPoint, (Point2d)Maths.sum((Point2d)startPoint, (Point2d)axis), (Point2d)endPoint, (MutableObject)right));
        Log.d((String)String.valueOf(dragButton.getId()), (String)("Angle: " + angle));
        Log.d((String)String.valueOf(dragButton.getId()), (String)("Is right?: " + right.getObject()));
        double duration = motionEvent.getEventTime() - motionEvent.getDownTime();
        Preference distancePreferences = this.preferences.getPreferencesMap().get((Object)PreferenceType.distance);
        Preference anglePreferences = this.preferences.getPreferencesMap().get((Object)PreferenceType.angle);
        DragDirection direction = null;
        for (Map.Entry<DragDirection, DragPreference> directionEntry : distancePreferences.getDirectionPreferences().entrySet()) {
            Log.d((String)String.valueOf(dragButton.getId()), (String)("Drag direction: " + (Object)((Object)directionEntry.getKey())));
            Log.d((String)String.valueOf(dragButton.getId()), (String)("Trying direction interval: " + directionEntry.getValue().getInterval()));
            if (!directionEntry.getValue().getInterval().contains((Comparable)Float.valueOf(distance))) continue;
            DragPreference anglePreference = anglePreferences.getDirectionPreferences().get((Object)directionEntry.getKey());
            Log.d((String)String.valueOf(dragButton.getId()), (String)("Trying angle interval: " + anglePreference.getInterval()));
            if (directionEntry.getKey() == DragDirection.left && ((Boolean)right.getObject()).booleanValue() || directionEntry.getKey() == DragDirection.right && !((Boolean)right.getObject()).booleanValue() || !anglePreference.getInterval().contains((Comparable)Float.valueOf((float)angle))) continue;
            direction = directionEntry.getKey();
            Log.d((String)String.valueOf(dragButton.getId()), (String)("MATCH! Direction: " + (Object)((Object)direction)));
            break;
        }
        if (direction != null) {
            Preference durationPreferences = this.preferences.getPreferencesMap().get((Object)PreferenceType.duration);
            DragPreference durationDragPreferences = durationPreferences.getDirectionPreferences().get((Object)direction);
            Log.d((String)String.valueOf(dragButton.getId()), (String)("Trying time interval: " + durationDragPreferences.getInterval()));
            if (durationDragPreferences.getInterval().contains((Comparable)Float.valueOf((float)duration))) {
                Log.d((String)String.valueOf(dragButton.getId()), (String)"MATCH!");
                result = this.dragProcessor.processDragEvent(direction, dragButton, startPoint, motionEvent);
            }
        }
        return result;
    }

    @Override
    public boolean isSuppressOnClickEvent() {
        return true;
    }

    private void logDragEvent(@Nonnull DragButton dragButton, @Nonnull DragEvent event) {
        if (dragButton == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.logDragEvent must not be null");
        }
        if (event == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.logDragEvent must not be null");
        }
        Point2d startPoint = event.getStartPoint();
        MotionEvent motionEvent = event.getMotionEvent();
        Point2d endPoint = new Point2d(motionEvent.getX(), motionEvent.getY());
        Log.d((String)String.valueOf(dragButton.getId()), (String)("Start point: " + startPoint + ", End point: " + endPoint));
        Log.d((String)String.valueOf(dragButton.getId()), (String)("Distance: " + Maths.getDistance((Point2d)startPoint, (Point2d)endPoint)));
        MutableObject right = new MutableObject();
        Log.d((String)String.valueOf(dragButton.getId()), (String)("Angle: " + Math.toDegrees(Maths.getAngle((Point2d)startPoint, (Point2d)Maths.sum((Point2d)startPoint, (Point2d)axis), (Point2d)endPoint, (MutableObject)right))));
        Log.d((String)String.valueOf(dragButton.getId()), (String)("Is right angle? " + right));
        Log.d((String)String.valueOf(dragButton.getId()), (String)("Axis: " + axis + " Vector: " + Maths.subtract((Point2d)endPoint, (Point2d)startPoint)));
        Log.d((String)String.valueOf(dragButton.getId()), (String)("Total time: " + (motionEvent.getEventTime() - motionEvent.getDownTime()) + " ms"));
    }

    @Nonnull
    public DragProcessor getDragProcessor() {
        DragProcessor dragProcessor = this.dragProcessor;
        if (dragProcessor == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/SimpleOnDragListener.getDragProcessor must not return null");
        }
        return dragProcessor;
    }

    public void setDragProcessor(@Nonnull DragProcessor dragProcessor) {
        if (dragProcessor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.setDragProcessor must not be null");
        }
        this.dragProcessor = dragProcessor;
    }

    @Override
    public void onDragPreferencesChange(@Nonnull Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.onDragPreferencesChange must not be null");
        }
        this.preferences = preferences;
    }

    public static String getPreferenceId(@Nonnull PreferenceType preferenceType, @Nonnull DragDirection direction) {
        if (preferenceType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.getPreferenceId must not be null");
        }
        if (direction == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.getPreferenceId must not be null");
        }
        return "org.solovyev.android.calculator.DragButtonCalibrationActivity_" + preferenceType.name();
    }

    @Nonnull
    public static Preferences getDefaultPreferences(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.getDefaultPreferences must not be null");
        }
        Preferences preferences = SimpleOnDragListener.getPreferences0(null, context);
        if (preferences == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/SimpleOnDragListener.getDefaultPreferences must not return null");
        }
        return preferences;
    }

    @Nonnull
    public static Preferences getPreferences(@Nonnull SharedPreferences preferences, @Nonnull Context context) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.getPreferences must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.getPreferences must not be null");
        }
        Preferences preferences2 = SimpleOnDragListener.getPreferences0(preferences, context);
        if (preferences2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/SimpleOnDragListener.getPreferences must not return null");
        }
        return preferences2;
    }

    @Nonnull
    private static Preferences getPreferences0(@Nullable SharedPreferences preferences, @Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.getPreferences0 must not be null");
        }
        NumberIntervalMapper mapper = NumberIntervalMapper.of(Float.class);
        Preferences result = new Preferences();
        for (PreferenceType preferenceType : PreferenceType.values()) {
            for (DragDirection dragDirection : DragDirection.values()) {
                String value;
                String defaultValue;
                String preferenceId = SimpleOnDragListener.getPreferenceId(preferenceType, dragDirection);
                switch (preferenceType) {
                    case angle: {
                        defaultValue = context.getResources().getString(R.string.p_drag_angle);
                        break;
                    }
                    case distance: {
                        defaultValue = context.getResources().getString(R.string.p_drag_distance);
                        break;
                    }
                    case duration: {
                        defaultValue = context.getResources().getString(R.string.p_drag_duration);
                        break;
                    }
                    default: {
                        defaultValue = null;
                        Log.e((String)SimpleOnDragListener.class.getName(), (String)("New preference type added: default preferences should be defined. Preference id: " + preferenceId));
                    }
                }
                String string2 = value = preferences == null ? defaultValue : preferences.getString(preferenceId, defaultValue);
                if (value == null) continue;
                Interval<Float> intervalPref = SimpleOnDragListener.transformInterval(preferenceType, dragDirection, (Interval<Float>)((Interval)mapper.parseValue(value)));
                Log.d((String)SimpleOnDragListener.class.getName(), (String)("Preference loaded for " + (Object)((Object)dragDirection) + ". Id: " + preferenceId + ", value: " + intervalPref.toString()));
                DragPreference directionPreference = new DragPreference(dragDirection, intervalPref);
                Preference preference = result.getPreferencesMap().get((Object)preferenceType);
                if (preference == null) {
                    preference = new Preference(preferenceType);
                    result.getPreferencesMap().put(preferenceType, preference);
                }
                preference.getDirectionPreferences().put(dragDirection, directionPreference);
            }
        }
        Preferences preferences2 = result;
        if (preferences2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/SimpleOnDragListener.getPreferences0 must not return null");
        }
        return preferences2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    public static Interval<Float> transformInterval(@Nonnull PreferenceType preferenceType, @Nonnull DragDirection dragDirection, @Nonnull Interval<Float> interval) {
        Interval interval2;
        if (preferenceType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.transformInterval must not be null");
        }
        if (dragDirection == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.transformInterval must not be null");
        }
        if (interval == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener.transformInterval must not be null");
        }
        if (preferenceType == PreferenceType.angle) {
            Float leftLimit = (Float)interval.getLeftLimit();
            Float rightLimit = (Float)interval.getRightLimit();
            if (leftLimit != null && rightLimit != null) {
                Float newRightLimit;
                Float newLeftLimit;
                if (dragDirection == DragDirection.up) {
                    newLeftLimit = Float.valueOf(180.0f - rightLimit.floatValue());
                    newRightLimit = Float.valueOf(180.0f - leftLimit.floatValue());
                } else if (dragDirection == DragDirection.left) {
                    newLeftLimit = Float.valueOf(90.0f - rightLimit.floatValue());
                    newRightLimit = Float.valueOf(90.0f + rightLimit.floatValue());
                } else if (dragDirection == DragDirection.right) {
                    newLeftLimit = Float.valueOf(90.0f - rightLimit.floatValue());
                    newRightLimit = Float.valueOf(90.0f + rightLimit.floatValue());
                } else {
                    newLeftLimit = leftLimit;
                    newRightLimit = rightLimit;
                }
                if ((interval2 = Intervals.newClosedInterval((Comparable)newLeftLimit, (Comparable)newRightLimit)) == null) throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/SimpleOnDragListener.transformInterval must not return null");
                return interval2;
            }
        }
        if ((interval2 = interval) != null) return interval2;
        throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/SimpleOnDragListener.transformInterval must not return null");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Preferences {
        private final Map<PreferenceType, Preference> preferencesMap = new HashMap<PreferenceType, Preference>();

        public Map<PreferenceType, Preference> getPreferencesMap() {
            return this.preferencesMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Preference {
        @Nonnull
        private PreferenceType preferenceType;
        @Nonnull
        private Map<DragDirection, DragPreference> directionPreferences;

        public Preference(@Nonnull PreferenceType preferenceType) {
            if (preferenceType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener$Preference.<init> must not be null");
            }
            this.directionPreferences = new HashMap<DragDirection, DragPreference>();
            this.preferenceType = preferenceType;
        }

        @Nonnull
        public PreferenceType getPreferenceType() {
            PreferenceType preferenceType = this.preferenceType;
            if (preferenceType == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/SimpleOnDragListener$Preference.getPreferenceType must not return null");
            }
            return preferenceType;
        }

        public void setPreferenceType(@Nonnull PreferenceType preferenceType) {
            if (preferenceType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener$Preference.setPreferenceType must not be null");
            }
            this.preferenceType = preferenceType;
        }

        @Nonnull
        public Map<DragDirection, DragPreference> getDirectionPreferences() {
            Map<DragDirection, DragPreference> map = this.directionPreferences;
            if (map == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/SimpleOnDragListener$Preference.getDirectionPreferences must not return null");
            }
            return map;
        }

        public void setDirectionPreferences(@Nonnull Map<DragDirection, DragPreference> directionPreferences) {
            if (directionPreferences == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener$Preference.setDirectionPreferences must not be null");
            }
            this.directionPreferences = directionPreferences;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DragPreference {
        @Nonnull
        private DragDirection direction;
        @Nonnull
        private Interval<Float> interval;

        public DragPreference(@Nonnull DragDirection direction, @Nonnull Interval<Float> interval) {
            if (direction == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener$DragPreference.<init> must not be null");
            }
            if (interval == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener$DragPreference.<init> must not be null");
            }
            this.direction = direction;
            this.interval = interval;
        }

        @Nonnull
        public DragDirection getDirection() {
            DragDirection dragDirection = this.direction;
            if (dragDirection == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/SimpleOnDragListener$DragPreference.getDirection must not return null");
            }
            return dragDirection;
        }

        public void setDirection(@Nonnull DragDirection direction) {
            if (direction == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener$DragPreference.setDirection must not be null");
            }
            this.direction = direction;
        }

        @Nonnull
        public Interval<Float> getInterval() {
            Interval<Float> interval = this.interval;
            if (interval == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/SimpleOnDragListener$DragPreference.getInterval must not return null");
            }
            return interval;
        }

        public void setInterval(@Nonnull Interval<Float> interval) {
            if (interval == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/SimpleOnDragListener$DragPreference.setInterval must not be null");
            }
            this.interval = interval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PreferenceType {
        angle,
        distance,
        duration;

    }

    public static interface DragProcessor {
        public boolean processDragEvent(@Nonnull DragDirection var1, @Nonnull DragButton var2, @Nonnull Point2d var3, @Nonnull MotionEvent var4);
    }
}

