/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view.drag;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.drag.DirectionDragButtonDef;
import org.solovyev.android.view.drag.DragDirection;

public class DirectionDragButtonDefImpl
implements DirectionDragButtonDef {
    @Nullable
    private CharSequence text;
    private Map<DragDirection, CharSequence> directionsTexts = new EnumMap<DragDirection, CharSequence>(DragDirection.class);
    @Nullable
    private Integer backgroundResId;
    @Nullable
    private Integer drawableResId;
    @Nullable
    private String tag;
    @Nullable
    private Float weight;
    @Nullable
    private Integer layoutMarginLeft;
    @Nullable
    private Integer layoutMarginRight;

    private DirectionDragButtonDefImpl() {
    }

    @Nonnull
    public static DirectionDragButtonDefImpl newInstance(@Nullable CharSequence text) {
        DirectionDragButtonDefImpl directionDragButtonDefImpl = DirectionDragButtonDefImpl.newInstance(text, null, null, null, null);
        if (directionDragButtonDefImpl == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButtonDefImpl.newInstance must not return null");
        }
        return directionDragButtonDefImpl;
    }

    @Nonnull
    public static DirectionDragButtonDefImpl newInstance(@Nullable CharSequence text, @Nullable CharSequence up, @Nullable CharSequence right, @Nullable CharSequence down, @Nullable CharSequence left) {
        DirectionDragButtonDefImpl directionDragButtonDefImpl = DirectionDragButtonDefImpl.newInstance(text, up, right, down, left, null);
        if (directionDragButtonDefImpl == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButtonDefImpl.newInstance must not return null");
        }
        return directionDragButtonDefImpl;
    }

    @Nonnull
    public static DirectionDragButtonDefImpl newInstance(@Nullable CharSequence text, @Nullable CharSequence up, @Nullable CharSequence right, @Nullable CharSequence down, @Nullable CharSequence left, @Nullable Integer backgroundColor) {
        DirectionDragButtonDefImpl result = new DirectionDragButtonDefImpl();
        result.text = text;
        result.directionsTexts.put(DragDirection.up, up);
        result.directionsTexts.put(DragDirection.right, right);
        result.directionsTexts.put(DragDirection.down, down);
        result.directionsTexts.put(DragDirection.left, left);
        result.backgroundResId = backgroundColor;
        DirectionDragButtonDefImpl directionDragButtonDefImpl = result;
        if (directionDragButtonDefImpl == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButtonDefImpl.newInstance must not return null");
        }
        return directionDragButtonDefImpl;
    }

    @Nonnull
    public static DirectionDragButtonDefImpl newDrawableInstance(@Nonnull Integer drawableResId) {
        if (drawableResId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButtonDefImpl.newDrawableInstance must not be null");
        }
        DirectionDragButtonDefImpl directionDragButtonDefImpl = DirectionDragButtonDefImpl.newDrawableInstance(drawableResId, null);
        if (directionDragButtonDefImpl == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButtonDefImpl.newDrawableInstance must not return null");
        }
        return directionDragButtonDefImpl;
    }

    @Nonnull
    public static DirectionDragButtonDefImpl newDrawableInstance(@Nonnull Integer drawableResId, @Nullable Integer backgroundColor) {
        if (drawableResId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButtonDefImpl.newDrawableInstance must not be null");
        }
        DirectionDragButtonDefImpl result = new DirectionDragButtonDefImpl();
        result.drawableResId = drawableResId;
        result.backgroundResId = backgroundColor;
        DirectionDragButtonDefImpl directionDragButtonDefImpl = result;
        if (directionDragButtonDefImpl == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButtonDefImpl.newDrawableInstance must not return null");
        }
        return directionDragButtonDefImpl;
    }

    @Nullable
    public CharSequence getText(@Nonnull DragDirection dragDirection) {
        if (dragDirection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButtonDefImpl.getText must not be null");
        }
        return this.directionsTexts.get((Object)dragDirection);
    }

    @Nullable
    public Float getLayoutWeight() {
        return this.weight;
    }

    @Nullable
    public Integer getLayoutMarginLeft() {
        return this.layoutMarginLeft;
    }

    @Nullable
    public Integer getLayoutMarginRight() {
        return this.layoutMarginRight;
    }

    @Nullable
    public Integer getDrawableResId() {
        return this.drawableResId;
    }

    @Nullable
    public String getTag() {
        return this.tag;
    }

    @Nullable
    public Integer getBackgroundResId() {
        return this.backgroundResId;
    }

    @Nullable
    public CharSequence getText() {
        return this.text;
    }

    public void setWeight(@Nullable Float weight) {
        this.weight = weight;
    }

    public void setLayoutMarginRight(@Nullable Integer layoutMarginRight) {
        this.layoutMarginRight = layoutMarginRight;
    }

    public void setLayoutMarginLeft(@Nullable Integer layoutMarginLeft) {
        this.layoutMarginLeft = layoutMarginLeft;
    }

    public void setBackgroundResId(int backgroundResId) {
        this.backgroundResId = backgroundResId;
    }

    public void setTag(@Nullable String tag) {
        this.tag = tag;
    }

    public void setText(@Nullable CharSequence text) {
        this.text = text;
    }

    public void setBackgroundResId(@Nullable Integer backgroundResId) {
        this.backgroundResId = backgroundResId;
    }

    public void setDrawableResId(@Nullable Integer drawableResId) {
        this.drawableResId = drawableResId;
    }

    public void setDirectionText(@Nonnull DragDirection key, @Nullable CharSequence text) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButtonDefImpl.setDirectionText must not be null");
        }
        this.directionsTexts.put(key, text);
    }
}

