/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view.drag;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.R;
import org.solovyev.android.view.drag.DirectionDragButtonDef;
import org.solovyev.android.view.drag.DragButton;
import org.solovyev.android.view.drag.DragDirection;
import org.solovyev.common.math.Point2d;
import org.solovyev.common.text.NumberParser;
import org.solovyev.common.text.Parser;
import org.solovyev.common.text.StringCollections;
import org.solovyev.common.text.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectionDragButton
extends DragButton {
    @Nonnull
    private static final Float DEFAULT_DIRECTION_TEXT_SCALE_FLOAT = Float.valueOf(0.33f);
    @Nonnull
    private static final Integer DEFAULT_DIRECTION_TEXT_ALPHA = 140;
    private static final int DEFAULT_DIRECTION_TEXT_COLOR = -1;
    @Nonnull
    private static final String DEFAULT_DIRECTION_TEXT_SCALE = "0.33;0.33;0.33;0.33";
    @Nonnull
    private final Map<GuiDragDirection, DirectionTextData> textDataMap;
    @Nonnull
    protected String directionTextScale;
    @Nonnull
    protected Integer directionTextAlpha;
    protected int directionTextColor;
    private boolean initialized;

    public DirectionDragButton(Context context, @Nonnull AttributeSet attrs) {
        if (attrs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.<init> must not be null");
        }
        super(context, attrs);
        this.textDataMap = new EnumMap<GuiDragDirection, DirectionTextData>(GuiDragDirection.class);
        this.directionTextScale = DEFAULT_DIRECTION_TEXT_SCALE;
        this.directionTextAlpha = DEFAULT_DIRECTION_TEXT_ALPHA;
        this.directionTextColor = -1;
        this.initialized = false;
        this.init(context, attrs);
    }

    public DirectionDragButton(Context context, @Nonnull DirectionDragButtonDef directionDragButtonDef) {
        if (directionDragButtonDef == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.<init> must not be null");
        }
        super(context, directionDragButtonDef);
        this.textDataMap = new EnumMap<GuiDragDirection, DirectionTextData>(GuiDragDirection.class);
        this.directionTextScale = DEFAULT_DIRECTION_TEXT_SCALE;
        this.directionTextAlpha = DEFAULT_DIRECTION_TEXT_ALPHA;
        this.directionTextColor = -1;
        this.initialized = false;
        this.init(context, directionDragButtonDef);
    }

    private void init(@Nonnull Context context, @Nonnull DirectionDragButtonDef directionDragButtonDef) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.init must not be null");
        }
        if (directionDragButtonDef == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.init must not be null");
        }
        for (GuiDragDirection direction : GuiDragDirection.values()) {
            CharSequence directionText = directionDragButtonDef.getText(direction.dragDirection);
            this.textDataMap.put(direction, new DirectionTextData(direction, Strings.getNotEmpty((CharSequence)directionText, (String)"")));
        }
        this.initialized = true;
    }

    public void applyDef(@Nonnull DirectionDragButtonDef directionDragButtonDef) {
        if (directionDragButtonDef == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.applyDef must not be null");
        }
        super.applyDef(directionDragButtonDef);
        for (GuiDragDirection guiDragDirection : GuiDragDirection.values()) {
            CharSequence directionText = directionDragButtonDef.getText(guiDragDirection.dragDirection);
            this.textDataMap.put(guiDragDirection, new DirectionTextData(guiDragDirection, Strings.getNotEmpty((CharSequence)directionText, (String)"")));
        }
    }

    private void init(@Nonnull Context context, @Nonnull AttributeSet attrs) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.init must not be null");
        }
        if (attrs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.init must not be null");
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DirectionDragButton);
        block0: for (int i = 0; i < a.getIndexCount(); ++i) {
            int attr2 = a.getIndex(i);
            if (!a.hasValue(attr2)) continue;
            if (attr2 == R.styleable.DirectionDragButton_directionTextColor) {
                this.directionTextColor = a.getColor(attr2, -1);
                continue;
            }
            if (attr2 == R.styleable.DirectionDragButton_directionTextScale) {
                this.directionTextScale = a.getString(attr2);
                continue;
            }
            if (attr2 == R.styleable.DirectionDragButton_directionTextAlpha) {
                this.directionTextAlpha = a.getInt(attr2, DEFAULT_DIRECTION_TEXT_ALPHA.intValue());
                continue;
            }
            for (GuiDragDirection guiDragDirection : GuiDragDirection.values()) {
                if (guiDragDirection.getAttributeId() != attr2) continue;
                this.textDataMap.put(guiDragDirection, new DirectionTextData(guiDragDirection, a.getString(attr2)));
                continue block0;
            }
        }
        a.recycle();
        for (Map.Entry<GuiDragDirection, Float> entry : this.getDirectionTextScales().entrySet()) {
            DirectionTextData td = this.textDataMap.get((Object)entry.getKey());
            if (td == null) continue;
            td.scale = entry.getValue();
        }
        this.initialized = true;
    }

    public void onSizeChanged(int w, int h, int oldW, int oldH) {
        this.measureText();
    }

    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        this.measureText();
    }

    protected void measureText() {
        if (this.initialized) {
            TextPaint basePaint = this.getPaint();
            for (DirectionTextData textData : this.textDataMap.values()) {
                this.initDirectionTextPaint((Paint)basePaint, textData);
                textData.position = textData.direction.getTextPosition((Paint)textData.paint, (Paint)basePaint, textData.text, this.getText(), this.getWidth(), this.getHeight());
            }
        }
    }

    protected void initDirectionTextPaint(@Nonnull Paint basePaint, @Nonnull DirectionTextData textData) {
        if (basePaint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.initDirectionTextPaint must not be null");
        }
        if (textData == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.initDirectionTextPaint must not be null");
        }
        textData.init(basePaint, this.directionTextColor, this.directionTextAlpha);
    }

    @Override
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        TextPaint paint = this.getPaint();
        for (DirectionTextData td : this.textDataMap.values()) {
            if (!td.show) continue;
            this.initDirectionTextPaint((Paint)paint, td);
            String text = td.text;
            Point2d position = td.position;
            canvas.drawText(text, 0, text.length(), position.getX(), position.getY(), (Paint)td.paint);
        }
    }

    @Nullable
    public String getTextUp() {
        return this.getText(GuiDragDirection.up);
    }

    @Nullable
    public String getTextDown() {
        return this.getText(GuiDragDirection.down);
    }

    @Nullable
    public String getText(@Nonnull DragDirection direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.getText must not be null");
        }
        GuiDragDirection guiDragDirection = GuiDragDirection.valueOf(direction);
        return guiDragDirection == null ? null : this.getText(guiDragDirection);
    }

    public void showDirectionText(boolean show, @Nonnull DragDirection direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.showDirectionText must not be null");
        }
        GuiDragDirection guiDragDirection = GuiDragDirection.valueOf(direction);
        DirectionTextData td = this.textDataMap.get((Object)guiDragDirection);
        if (td != null) {
            td.show = show;
        }
    }

    @Nullable
    private String getText(@Nonnull GuiDragDirection direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton.getText must not be null");
        }
        DirectionTextData td = this.textDataMap.get((Object)direction);
        if (td == null) {
            return null;
        }
        if (td.show) {
            return td.text;
        }
        return null;
    }

    @Nonnull
    public String getDirectionTextScale() {
        String string2 = this.directionTextScale;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton.getDirectionTextScale must not return null");
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private Map<GuiDragDirection, Float> getDirectionTextScales() {
        void var5_9;
        List scales = StringCollections.split((String)this.getDirectionTextScale(), (String)";", (Parser)NumberParser.of(Float.class));
        HashMap<GuiDragDirection, Float> result = new HashMap<GuiDragDirection, Float>();
        GuiDragDirection[] arr$ = GuiDragDirection.values();
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_9 < len$) {
            GuiDragDirection direction = arr$[var5_9];
            result.put(direction, DEFAULT_DIRECTION_TEXT_SCALE_FLOAT);
            ++var5_9;
        }
        if (scales.size() == 1) {
            Float scale = (Float)scales.get(0);
            for (Map.Entry entry : result.entrySet()) {
                entry.setValue(scale);
            }
        } else {
            for (int i = 0; i < scales.size(); ++i) {
                for (GuiDragDirection direction : GuiDragDirection.values()) {
                    if (direction.getAttributePosition() != i) continue;
                    result.put(direction, (Float)scales.get(i));
                }
            }
        }
        HashMap<GuiDragDirection, Float> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton.getDirectionTextScales must not return null");
        }
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum GuiDragDirection {
        up(DragDirection.up, 0){

            public int getAttributeId() {
                return R.styleable.DirectionDragButton_textUp;
            }

            @Nonnull
            public Point2d getTextPosition(@Nonnull Paint paint, @Nonnull Paint basePaint, @Nonnull CharSequence text, CharSequence baseText, int w, int h) {
                if (paint == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$1.getTextPosition must not be null");
                }
                if (basePaint == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$1.getTextPosition must not be null");
                }
                if (text == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$1.getTextPosition must not be null");
                }
                Point2d point2d = GuiDragDirection.getUpDownTextPosition(paint, basePaint, text, baseText, 1.0f, w, h);
                if (point2d == null) {
                    throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$1.getTextPosition must not return null");
                }
                return point2d;
            }
        }
        ,
        down(DragDirection.down, 2){

            public int getAttributeId() {
                return R.styleable.DirectionDragButton_textDown;
            }

            @Nonnull
            public Point2d getTextPosition(@Nonnull Paint paint, @Nonnull Paint basePaint, @Nonnull CharSequence text, CharSequence baseText, int w, int h) {
                if (paint == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$2.getTextPosition must not be null");
                }
                if (basePaint == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$2.getTextPosition must not be null");
                }
                if (text == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$2.getTextPosition must not be null");
                }
                Point2d point2d = GuiDragDirection.getUpDownTextPosition(paint, basePaint, text, baseText, -1.0f, w, h);
                if (point2d == null) {
                    throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$2.getTextPosition must not return null");
                }
                return point2d;
            }
        }
        ,
        left(DragDirection.left, 3){

            public int getAttributeId() {
                return R.styleable.DirectionDragButton_textLeft;
            }

            @Nonnull
            public Point2d getTextPosition(@Nonnull Paint paint, @Nonnull Paint basePaint, @Nonnull CharSequence text, CharSequence baseText, int w, int h) {
                if (paint == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$3.getTextPosition must not be null");
                }
                if (basePaint == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$3.getTextPosition must not be null");
                }
                if (text == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$3.getTextPosition must not be null");
                }
                Point2d point2d = GuiDragDirection.getLeftRightTextPosition(paint, basePaint, text, baseText, w, h, true);
                if (point2d == null) {
                    throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$3.getTextPosition must not return null");
                }
                return point2d;
            }
        }
        ,
        right(DragDirection.right, 1){

            public int getAttributeId() {
                return R.styleable.DirectionDragButton_textRight;
            }

            @Nonnull
            public Point2d getTextPosition(@Nonnull Paint paint, @Nonnull Paint basePaint, @Nonnull CharSequence text, CharSequence baseText, int w, int h) {
                if (paint == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$4.getTextPosition must not be null");
                }
                if (basePaint == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$4.getTextPosition must not be null");
                }
                if (text == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$4.getTextPosition must not be null");
                }
                Point2d point2d = GuiDragDirection.getLeftRightTextPosition(paint, basePaint, text, baseText, w, h, false);
                if (point2d == null) {
                    throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection$4.getTextPosition must not return null");
                }
                return point2d;
            }
        };

        @Nonnull
        private final DragDirection dragDirection;
        private final int attributePosition;

        private GuiDragDirection(DragDirection dragDirection, int attributePosition) {
            if (dragDirection == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection.<init> must not be null");
            }
            this.dragDirection = dragDirection;
            this.attributePosition = attributePosition;
        }

        public abstract int getAttributeId();

        public int getAttributePosition() {
            return this.attributePosition;
        }

        @Nonnull
        public abstract Point2d getTextPosition(@Nonnull Paint var1, @Nonnull Paint var2, @Nonnull CharSequence var3, CharSequence var4, int var5, int var6);

        @Nonnull
        private static Point2d getLeftRightTextPosition(@Nonnull Paint paint, @Nonnull Paint basePaint, CharSequence text, @Nonnull CharSequence baseText, int w, int h, boolean left) {
            float width;
            if (paint == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection.getLeftRightTextPosition must not be null");
            }
            if (basePaint == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection.getLeftRightTextPosition must not be null");
            }
            if (baseText == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection.getLeftRightTextPosition must not be null");
            }
            Point2d result = new Point2d();
            if (left) {
                width = paint.measureText(" ");
                result.setX(width);
            } else {
                width = paint.measureText(text.toString() + " ");
                result.setX((float)w - width);
            }
            float selfHeight = paint.ascent() + paint.descent();
            basePaint.measureText(Strings.getNotEmpty((CharSequence)baseText, (String)"|"));
            result.setY((float)(h / 2) - selfHeight / 2.0f);
            Point2d point2d = result;
            if (point2d == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection.getLeftRightTextPosition must not return null");
            }
            return point2d;
        }

        @Nonnull
        private static Point2d getUpDownTextPosition(@Nonnull Paint paint, @Nonnull Paint basePaint, @Nonnull CharSequence text, CharSequence baseText, float direction, int w, int h) {
            if (paint == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection.getUpDownTextPosition must not be null");
            }
            if (basePaint == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection.getUpDownTextPosition must not be null");
            }
            if (text == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection.getUpDownTextPosition must not be null");
            }
            Point2d result = new Point2d();
            float width = paint.measureText(text.toString() + " ");
            result.setX((float)w - width);
            float selfHeight = paint.ascent() + paint.descent();
            basePaint.measureText(Strings.getNotEmpty((CharSequence)baseText, (String)"|"));
            if (direction < 0.0f) {
                result.setY((float)(h / 2 + h / 3) - selfHeight / 2.0f);
            } else {
                result.setY((float)(h / 2 - h / 3) - selfHeight / 2.0f);
            }
            Point2d point2d = result;
            if (point2d == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection.getUpDownTextPosition must not return null");
            }
            return point2d;
        }

        @Nullable
        public static GuiDragDirection valueOf(@Nonnull DragDirection dragDirection) {
            if (dragDirection == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$GuiDragDirection.valueOf must not be null");
            }
            for (GuiDragDirection guiDragDirection : GuiDragDirection.values()) {
                if (guiDragDirection.dragDirection != dragDirection) continue;
                return guiDragDirection;
            }
            return null;
        }
    }

    protected static class DirectionTextData {
        @Nonnull
        private final GuiDragDirection direction;
        @Nonnull
        private String text;
        @Nonnull
        private Point2d position;
        @Nonnull
        private final TextPaint paint;
        @Nonnull
        private Float scale;
        private boolean show;

        private DirectionTextData(@Nonnull GuiDragDirection direction, @Nonnull String text) {
            if (direction == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$DirectionTextData.<init> must not be null");
            }
            if (text == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$DirectionTextData.<init> must not be null");
            }
            this.paint = new TextPaint();
            this.scale = Float.valueOf(0.5f);
            this.show = true;
            this.direction = direction;
            this.text = text;
        }

        protected void init(@Nonnull Paint basePaint, int color2, int alpha) {
            if (basePaint == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/drag/DirectionDragButton$DirectionTextData.init must not be null");
            }
            this.paint.set(basePaint);
            this.paint.setColor(color2);
            this.paint.setAlpha(alpha);
            this.paint.setTextSize(basePaint.getTextSize() * this.scale.floatValue());
        }

        @Nonnull
        public GuiDragDirection getDirection() {
            GuiDragDirection guiDragDirection = this.direction;
            if (guiDragDirection == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton$DirectionTextData.getDirection must not return null");
            }
            return guiDragDirection;
        }

        @Nonnull
        public String getText() {
            String string2 = this.text;
            if (string2 == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton$DirectionTextData.getText must not return null");
            }
            return string2;
        }

        @Nonnull
        public Point2d getPosition() {
            Point2d point2d = this.position;
            if (point2d == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton$DirectionTextData.getPosition must not return null");
            }
            return point2d;
        }

        @Nonnull
        public TextPaint getPaint() {
            TextPaint textPaint = this.paint;
            if (textPaint == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton$DirectionTextData.getPaint must not return null");
            }
            return textPaint;
        }

        @Nonnull
        public Float getScale() {
            Float f = this.scale;
            if (f == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/drag/DirectionDragButton$DirectionTextData.getScale must not return null");
            }
            return f;
        }

        public boolean isShow() {
            return this.show;
        }
    }
}

