/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.ViewBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewFromLayoutBuilder<V extends View>
implements ViewBuilder<V> {
    private final int layoutId;
    private final int viewId;
    private final boolean wholeLayout;
    @Nullable
    private LayoutInflater layoutInflater;

    private ViewFromLayoutBuilder(int layoutId, int viewId, boolean wholeLayout) {
        this.layoutId = layoutId;
        this.viewId = viewId;
        this.wholeLayout = wholeLayout;
    }

    @Nonnull
    public static <V extends View> ViewFromLayoutBuilder<V> newInstance(int layoutId, int viewId) {
        ViewFromLayoutBuilder<V> viewFromLayoutBuilder = new ViewFromLayoutBuilder<V>(layoutId, viewId, false);
        if (viewFromLayoutBuilder == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/ViewFromLayoutBuilder.newInstance must not return null");
        }
        return viewFromLayoutBuilder;
    }

    @Nonnull
    public static <V extends View> ViewFromLayoutBuilder<V> newInstance(int layoutId) {
        ViewFromLayoutBuilder<V> viewFromLayoutBuilder = new ViewFromLayoutBuilder<V>(layoutId, 0, true);
        if (viewFromLayoutBuilder == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/ViewFromLayoutBuilder.newInstance must not return null");
        }
        return viewFromLayoutBuilder;
    }

    public void setLayoutInflater(@Nullable LayoutInflater layoutInflater) {
        this.layoutInflater = layoutInflater;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nonnull
    public V build(@Nonnull Context context) {
        View view;
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/ViewFromLayoutBuilder.build must not be null");
        }
        LayoutInflater li = this.layoutInflater;
        if (li == null) {
            li = (LayoutInflater)context.getSystemService("layout_inflater");
        }
        if (this.wholeLayout) {
            view = li.inflate(this.layoutId, null);
            if (view == null) throw new IllegalStateException("@NotNull method org/solovyev/android/view/ViewFromLayoutBuilder.build must not return null");
            return (V)view;
        }
        ViewGroup itemView = (ViewGroup)li.inflate(this.layoutId, null);
        view = itemView.findViewById(this.viewId);
        if (view != null) return (V)view;
        throw new IllegalStateException("@NotNull method org/solovyev/android/view/ViewFromLayoutBuilder.build must not return null");
    }
}

