/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import java.math.BigDecimal;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum NumberType {
    LONG(Long.class),
    DOUBLE(Double.class),
    INTEGER(Integer.class),
    FLOAT(Float.class),
    SHORT(Short.class),
    BYTE(Byte.class),
    BIG_DECIMAL(BigDecimal.class);

    @Nonnull
    private final Class underlyingClass;

    private NumberType(Class underlyingClass) {
        if (underlyingClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/NumberType.<init> must not be null");
        }
        this.underlyingClass = underlyingClass;
    }

    @Nonnull
    public static <E extends Number> NumberType fromNumber(E value) throws IllegalArgumentException {
        for (NumberType numberType : NumberType.values()) {
            if (!numberType.underlyingClass.isInstance(value)) continue;
            NumberType numberType2 = numberType;
            if (numberType2 == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/view/NumberType.fromNumber must not return null");
            }
            return numberType2;
        }
        throw new IllegalArgumentException("Number class '" + value.getClass().getName() + "' is not supported");
    }

    public <T extends Number> T toNumber(double value) {
        switch (this) {
            case LONG: {
                return (T)new Long((long)value);
            }
            case DOUBLE: {
                return (T)new Double(value);
            }
            case INTEGER: {
                return (T)new Integer((int)value);
            }
            case FLOAT: {
                return (T)new Float((float)value);
            }
            case SHORT: {
                return (T)new Short((short)value);
            }
            case BYTE: {
                return (T)new Byte((byte)value);
            }
            case BIG_DECIMAL: {
                return (T)new BigDecimal(value);
            }
        }
        throw new InstantiationError("can't convert " + (Object)((Object)this) + " to a Number object");
    }
}

