/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.content.Context;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.AbstractRangeSeekBar;
import org.solovyev.android.view.NumberType;
import org.solovyev.common.Converter;
import org.solovyev.common.interval.Interval;
import org.solovyev.common.math.NumberValuer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberRangeSeekBar<T extends Number>
extends AbstractRangeSeekBar<T> {
    @Nonnull
    private final NumberType numberType;

    public NumberRangeSeekBar(@Nonnull Interval<T> boundaries, @Nullable Integer steps, Context context) throws IllegalArgumentException {
        if (boundaries == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/NumberRangeSeekBar.<init> must not be null");
        }
        this((Number)((Object)boundaries.getLeftLimit()), (Number)((Object)boundaries.getRightLimit()), steps, context);
    }

    public NumberRangeSeekBar(@Nonnull T minValue, @Nonnull T maxValue, @Nullable Integer steps, Context context) throws IllegalArgumentException {
        if (minValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/NumberRangeSeekBar.<init> must not be null");
        }
        if (maxValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/NumberRangeSeekBar.<init> must not be null");
        }
        super(minValue, maxValue, steps, context);
        this.numberType = NumberType.fromNumber(minValue);
    }

    @Override
    @Nonnull
    protected Converter<Double, T> getToTConverter() {
        Converter converter = new Converter<Double, T>(){

            @Nonnull
            public T convert(@Nonnull Double value) {
                if (value == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/NumberRangeSeekBar$1.convert must not be null");
                }
                Object t = NumberRangeSeekBar.this.numberType.toNumber(value);
                if (t == null) {
                    throw new IllegalStateException("@NotNull method org/solovyev/android/view/NumberRangeSeekBar$1.convert must not return null");
                }
                return t;
            }
        };
        if (converter == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/NumberRangeSeekBar.getToTConverter must not return null");
        }
        return converter;
    }

    @Override
    @Nonnull
    protected Converter<T, Double> getToDoubleConverter() {
        NumberValuer numberValuer = new NumberValuer();
        if (numberValuer == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/NumberRangeSeekBar.getToDoubleConverter must not return null");
        }
        return numberValuer;
    }
}

