/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.Picker;
import org.solovyev.common.text.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NumberRange<N extends Number>
implements Picker.Range<N> {
    @Nullable
    private Formatter<N> formatter;
    @Nonnull
    private final N min;
    @Nonnull
    private final N max;
    @Nonnull
    private final N step;
    private final int startPosition;
    private int count;

    public NumberRange(@Nonnull N min, @Nonnull N max, @Nonnull N step, int startPosition, @Nullable Formatter<N> formatter) {
        if (min == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/NumberRange.<init> must not be null");
        }
        if (max == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/NumberRange.<init> must not be null");
        }
        if (step == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/NumberRange.<init> must not be null");
        }
        this.count = -1;
        assert (((Comparable)min).compareTo(max) <= 0);
        this.min = min;
        this.max = max;
        this.step = step;
        this.startPosition = startPosition;
        this.formatter = formatter;
    }

    @Override
    public int getStartPosition() {
        if (this.startPosition < this.getCount()) {
            return this.startPosition;
        }
        return this.getCount() - 1;
    }

    @Override
    public int getCount() {
        if (this.count == -1) {
            this.count = this.getCount(this.min, this.max, this.step);
        }
        return this.count;
    }

    protected abstract int getCount(@Nonnull N var1, @Nonnull N var2, @Nonnull N var3);

    @Override
    @Nonnull
    public String getStringValueAt(int position) {
        int count = this.getCount();
        if (position < 0 || position >= count) {
            throw new IllegalArgumentException("Position " + position + " must be >= 0 and < " + count + "!");
        }
        N number = this.getValueAt(position, this.min, this.max, this.step);
        String string2 = this.formatter == null ? number.toString() : this.formatter.formatValue(number);
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/NumberRange.getStringValueAt must not return null");
        }
        return string2;
    }

    @Override
    @Nonnull
    public N getValueAt(int position) {
        N n = this.getValueAt(position, this.min, this.max, this.step);
        if (n == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/NumberRange.getValueAt must not return null");
        }
        return n;
    }

    @Nonnull
    protected abstract N getValueAt(int var1, @Nonnull N var2, @Nonnull N var3, @Nonnull N var4);
}

