/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.NumberRange;
import org.solovyev.common.text.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerRange
extends NumberRange<Integer> {
    public IntegerRange(@Nonnull Integer min, @Nonnull Integer max, @Nonnull Integer step, int startPosition, @Nullable Formatter<Integer> formatter) {
        if (min == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/IntegerRange.<init> must not be null");
        }
        if (max == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/IntegerRange.<init> must not be null");
        }
        if (step == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/IntegerRange.<init> must not be null");
        }
        super(min, max, step, startPosition, formatter);
    }

    @Nonnull
    public static NumberRange<Integer> newInstance(@Nonnull Integer min, @Nonnull Integer max, @Nonnull Integer step, @Nonnull Integer selected) {
        if (min == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/IntegerRange.newInstance must not be null");
        }
        if (max == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/IntegerRange.newInstance must not be null");
        }
        if (step == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/IntegerRange.newInstance must not be null");
        }
        if (selected == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/solovyev/android/view/IntegerRange.newInstance must not be null");
        }
        if (selected < min || selected > max) {
            throw new IllegalArgumentException("Selected value: " + selected + " should be >= " + min + " and <= " + max + "!");
        }
        int startPosition = 0;
        for (int i = min.intValue(); i < selected; i += step.intValue()) {
            ++startPosition;
        }
        IntegerRange integerRange = new IntegerRange(min, max, step, startPosition, null);
        if (integerRange == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/IntegerRange.newInstance must not return null");
        }
        return integerRange;
    }

    @Override
    protected int getCount(@Nonnull Integer min, @Nonnull Integer max, @Nonnull Integer step) {
        if (min == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/IntegerRange.getCount must not be null");
        }
        if (max == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/IntegerRange.getCount must not be null");
        }
        if (step == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/IntegerRange.getCount must not be null");
        }
        return (max - min) / step + 1;
    }

    @Override
    @Nonnull
    protected Integer getValueAt(int position, @Nonnull Integer min, @Nonnull Integer max, @Nonnull Integer step) {
        if (min == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/IntegerRange.getValueAt must not be null");
        }
        if (max == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/view/IntegerRange.getValueAt must not be null");
        }
        if (step == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/solovyev/android/view/IntegerRange.getValueAt must not be null");
        }
        Integer n = min + position * step;
        if (n == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/IntegerRange.getValueAt must not return null");
        }
        return n;
    }
}

