/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import org.solovyev.android.view.R;

public class FlowLayout
extends ViewGroup {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int horizontalSpacing = 0;
    private int verticalSpacing = 0;
    private int orientation = 0;
    private boolean debugDraw = false;

    public FlowLayout(Context context) {
        super(context);
        this.readStyleParameters(context, null);
    }

    public FlowLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.readStyleParameters(context, attributeSet);
    }

    public FlowLayout(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
        this.readStyleParameters(context, attributeSet);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int mode;
        int size;
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingRight() - this.getPaddingLeft();
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec) - this.getPaddingRight() - this.getPaddingLeft();
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (this.orientation == 0) {
            size = sizeWidth;
            mode = modeWidth;
        } else {
            size = sizeHeight;
            mode = modeHeight;
        }
        int lineThicknessWithSpacing = 0;
        int lineThickness = 0;
        int lineLengthWithSpacing = 0;
        int prevLinePosition = 0;
        int controlMaxLength = 0;
        int controlMaxThickness = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            int posY;
            int posX;
            boolean newLine;
            int spacingThickness;
            int spacingLength;
            int childThickness;
            int childLength;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)sizeWidth, (int)(modeWidth == 0x40000000 ? Integer.MIN_VALUE : modeWidth)), View.MeasureSpec.makeMeasureSpec((int)sizeHeight, (int)(modeHeight == 0x40000000 ? Integer.MIN_VALUE : modeHeight)));
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int hSpacing = this.getHorizontalSpacing(lp);
            int vSpacing = this.getVerticalSpacing(lp);
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (this.orientation == 0) {
                childLength = childWidth;
                childThickness = childHeight;
                spacingLength = hSpacing;
                spacingThickness = vSpacing;
            } else {
                childLength = childHeight;
                childThickness = childWidth;
                spacingLength = vSpacing;
                spacingThickness = hSpacing;
            }
            int lineLength = lineLengthWithSpacing + childLength;
            lineLengthWithSpacing = lineLength + spacingLength;
            boolean bl = newLine = lp.newLine || mode != 0 && lineLength > size;
            if (newLine) {
                prevLinePosition += lineThicknessWithSpacing;
                lineThickness = childThickness;
                lineLength = childLength;
                lineThicknessWithSpacing = childThickness + spacingThickness;
                lineLengthWithSpacing = lineLength + spacingLength;
            }
            lineThicknessWithSpacing = Math.max(lineThicknessWithSpacing, childThickness + spacingThickness);
            lineThickness = Math.max(lineThickness, childThickness);
            if (this.orientation == 0) {
                posX = this.getPaddingLeft() + lineLength - childLength;
                posY = this.getPaddingTop() + prevLinePosition;
            } else {
                posX = this.getPaddingLeft() + prevLinePosition;
                posY = this.getPaddingTop() + lineLength - childHeight;
            }
            lp.setPosition(posX, posY);
            controlMaxLength = Math.max(controlMaxLength, lineLength);
            controlMaxThickness = prevLinePosition + lineThickness;
        }
        if (this.orientation == 0) {
            this.setMeasuredDimension(FlowLayout.resolveSize((int)controlMaxLength, (int)widthMeasureSpec), FlowLayout.resolveSize((int)controlMaxThickness, (int)heightMeasureSpec));
        } else {
            this.setMeasuredDimension(FlowLayout.resolveSize((int)controlMaxThickness, (int)widthMeasureSpec), FlowLayout.resolveSize((int)controlMaxLength, (int)heightMeasureSpec));
        }
    }

    private int getVerticalSpacing(LayoutParams lp) {
        int vSpacing = lp.verticalSpacingSpecified() ? lp.verticalSpacing : this.verticalSpacing;
        return vSpacing;
    }

    private int getHorizontalSpacing(LayoutParams lp) {
        int hSpacing = lp.horizontalSpacingSpecified() ? lp.horizontalSpacing : this.horizontalSpacing;
        return hSpacing;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.layout(lp.x, lp.y, lp.x + child.getMeasuredWidth(), lp.y + child.getMeasuredHeight());
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean more = super.drawChild(canvas, child, drawingTime);
        this.drawDebugInfo(canvas, child);
        return more;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStyleParameters(Context context, AttributeSet attributeSet) {
        TypedArray a = context.obtainStyledAttributes(attributeSet, R.styleable.FlowLayout);
        try {
            this.horizontalSpacing = a.getDimensionPixelSize(R.styleable.FlowLayout_horizontalSpacing, 0);
            this.verticalSpacing = a.getDimensionPixelSize(R.styleable.FlowLayout_verticalSpacing, 0);
            this.orientation = a.getInteger(R.styleable.FlowLayout_orientation, 0);
            this.debugDraw = a.getBoolean(R.styleable.FlowLayout_debugDraw, false);
        }
        finally {
            a.recycle();
        }
    }

    private void drawDebugInfo(Canvas canvas, View child) {
        float y;
        float x;
        if (!this.debugDraw) {
            return;
        }
        Paint childPaint = this.createPaint(-256);
        Paint layoutPaint = this.createPaint(-16711936);
        Paint newLinePaint = this.createPaint(-65536);
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.horizontalSpacing > 0) {
            x = child.getRight();
            y = (float)child.getTop() + (float)child.getHeight() / 2.0f;
            canvas.drawLine(x, y, x + (float)lp.horizontalSpacing, y, childPaint);
            canvas.drawLine(x + (float)lp.horizontalSpacing - 4.0f, y - 4.0f, x + (float)lp.horizontalSpacing, y, childPaint);
            canvas.drawLine(x + (float)lp.horizontalSpacing - 4.0f, y + 4.0f, x + (float)lp.horizontalSpacing, y, childPaint);
        } else if (this.horizontalSpacing > 0) {
            x = child.getRight();
            y = (float)child.getTop() + (float)child.getHeight() / 2.0f;
            canvas.drawLine(x, y, x + (float)this.horizontalSpacing, y, layoutPaint);
            canvas.drawLine(x + (float)this.horizontalSpacing - 4.0f, y - 4.0f, x + (float)this.horizontalSpacing, y, layoutPaint);
            canvas.drawLine(x + (float)this.horizontalSpacing - 4.0f, y + 4.0f, x + (float)this.horizontalSpacing, y, layoutPaint);
        }
        if (lp.verticalSpacing > 0) {
            x = (float)child.getLeft() + (float)child.getWidth() / 2.0f;
            y = child.getBottom();
            canvas.drawLine(x, y, x, y + (float)lp.verticalSpacing, childPaint);
            canvas.drawLine(x - 4.0f, y + (float)lp.verticalSpacing - 4.0f, x, y + (float)lp.verticalSpacing, childPaint);
            canvas.drawLine(x + 4.0f, y + (float)lp.verticalSpacing - 4.0f, x, y + (float)lp.verticalSpacing, childPaint);
        } else if (this.verticalSpacing > 0) {
            x = (float)child.getLeft() + (float)child.getWidth() / 2.0f;
            y = child.getBottom();
            canvas.drawLine(x, y, x, y + (float)this.verticalSpacing, layoutPaint);
            canvas.drawLine(x - 4.0f, y + (float)this.verticalSpacing - 4.0f, x, y + (float)this.verticalSpacing, layoutPaint);
            canvas.drawLine(x + 4.0f, y + (float)this.verticalSpacing - 4.0f, x, y + (float)this.verticalSpacing, layoutPaint);
        }
        if (lp.newLine) {
            if (this.orientation == 0) {
                x = child.getLeft();
                y = (float)child.getTop() + (float)child.getHeight() / 2.0f;
                canvas.drawLine(x, y - 6.0f, x, y + 6.0f, newLinePaint);
            } else {
                x = (float)child.getLeft() + (float)child.getWidth() / 2.0f;
                y = child.getTop();
                canvas.drawLine(x - 6.0f, y, x + 6.0f, y, newLinePaint);
            }
        }
    }

    private Paint createPaint(int color2) {
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(color2);
        paint.setStrokeWidth(2.0f);
        return paint;
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        private static int NO_SPACING = -1;
        private int x;
        private int y;
        private int horizontalSpacing = NO_SPACING;
        private int verticalSpacing = NO_SPACING;
        private boolean newLine = false;

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.readStyleParameters(context, attributeSet);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public boolean horizontalSpacingSpecified() {
            return this.horizontalSpacing != NO_SPACING;
        }

        public boolean verticalSpacingSpecified() {
            return this.verticalSpacing != NO_SPACING;
        }

        public void setPosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readStyleParameters(Context context, AttributeSet attributeSet) {
            TypedArray a = context.obtainStyledAttributes(attributeSet, R.styleable.FlowLayout_LayoutParams);
            try {
                this.horizontalSpacing = a.getDimensionPixelSize(R.styleable.FlowLayout_LayoutParams_layout_horizontalSpacing, NO_SPACING);
                this.verticalSpacing = a.getDimensionPixelSize(R.styleable.FlowLayout_LayoutParams_layout_verticalSpacing, NO_SPACING);
                this.newLine = a.getBoolean(R.styleable.FlowLayout_LayoutParams_layout_newLine, false);
            }
            finally {
                a.recycle();
            }
        }
    }
}

