/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.graphics.drawable.Drawable;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.common.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawableFromIsConverter
implements Converter<InputStream, Drawable> {
    @Nonnull
    private static final DrawableFromIsConverter instance = new DrawableFromIsConverter("instance");
    @Nonnull
    private final String name;
    @Nullable
    private final Drawable defaultDrawable;

    public DrawableFromIsConverter(@Nonnull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/DrawableFromIsConverter.<init> must not be null");
        }
        this(name, null);
    }

    public DrawableFromIsConverter(@Nonnull String name, @Nullable Drawable defaultDrawable) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/DrawableFromIsConverter.<init> must not be null");
        }
        this.name = name;
        this.defaultDrawable = defaultDrawable;
    }

    @Nonnull
    public static DrawableFromIsConverter getInstance() {
        DrawableFromIsConverter drawableFromIsConverter = instance;
        if (drawableFromIsConverter == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/DrawableFromIsConverter.getInstance must not return null");
        }
        return drawableFromIsConverter;
    }

    @Nonnull
    public Drawable convert(@Nonnull InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/DrawableFromIsConverter.convert must not be null");
        }
        Drawable result = Drawable.createFromStream((InputStream)inputStream, (String)this.name);
        if (result == null) {
            result = this.defaultDrawable;
        }
        if (result == null) {
            throw new DrawableConversionFailedException();
        }
        Drawable drawable2 = result;
        if (drawable2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/DrawableFromIsConverter.convert must not return null");
        }
        return drawable2;
    }

    public static class DrawableConversionFailedException
    extends RuntimeException {
    }
}

