/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorMatrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;

public class ColorPickerDialog
extends Dialog {
    private OnColorChangedListener mListener;
    private int mInitialColor;

    public ColorPickerDialog(Context context, OnColorChangedListener listener, int initialColor) {
        super(context);
        this.mListener = listener;
        this.mInitialColor = initialColor;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        OnColorChangedListener l = new OnColorChangedListener(){

            public void colorChanged(int color2) {
                ColorPickerDialog.this.mListener.colorChanged(color2);
                ColorPickerDialog.this.dismiss();
            }
        };
        this.setContentView(new ColorPickerView(this.getContext(), l, this.mInitialColor));
        this.setTitle("Pick a Color");
    }

    private static class ColorPickerView
    extends View {
        private Paint mPaint;
        private Paint mCenterPaint;
        private final int[] mColors;
        private OnColorChangedListener mListener;
        private boolean mTrackingCenter;
        private boolean mHighlightCenter;
        private static final int CENTER_X = 100;
        private static final int CENTER_Y = 100;
        private static final int CENTER_RADIUS = 32;
        private static final float PI = 3.1415925f;

        ColorPickerView(Context c, OnColorChangedListener l, int color2) {
            super(c);
            this.mListener = l;
            this.mColors = new int[]{-65536, -65281, -16776961, -16711681, -16711936, -256, -65536};
            SweepGradient s = new SweepGradient(0.0f, 0.0f, this.mColors, null);
            this.mPaint = new Paint(1);
            this.mPaint.setShader((Shader)s);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(32.0f);
            this.mCenterPaint = new Paint(1);
            this.mCenterPaint.setColor(color2);
            this.mCenterPaint.setStrokeWidth(5.0f);
        }

        protected void onDraw(Canvas canvas) {
            float r = 100.0f - this.mPaint.getStrokeWidth() * 0.5f;
            canvas.translate(100.0f, 100.0f);
            canvas.drawOval(new RectF(-r, -r, r, r), this.mPaint);
            canvas.drawCircle(0.0f, 0.0f, 32.0f, this.mCenterPaint);
            if (this.mTrackingCenter) {
                int c = this.mCenterPaint.getColor();
                this.mCenterPaint.setStyle(Paint.Style.STROKE);
                if (this.mHighlightCenter) {
                    this.mCenterPaint.setAlpha(255);
                } else {
                    this.mCenterPaint.setAlpha(128);
                }
                canvas.drawCircle(0.0f, 0.0f, 32.0f + this.mCenterPaint.getStrokeWidth(), this.mCenterPaint);
                this.mCenterPaint.setStyle(Paint.Style.FILL);
                this.mCenterPaint.setColor(c);
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(200, 200);
        }

        private int floatToByte(float x) {
            int n = Math.round(x);
            return n;
        }

        private int pinToByte(int n) {
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            return n;
        }

        private int ave(int s, int d, float p) {
            return s + Math.round(p * (float)(d - s));
        }

        private int interpColor(int[] colors, float unit) {
            if (unit <= 0.0f) {
                return colors[0];
            }
            if (unit >= 1.0f) {
                return colors[colors.length - 1];
            }
            float p = unit * (float)(colors.length - 1);
            int i = (int)p;
            int c0 = colors[i];
            int c1 = colors[i + 1];
            int a = this.ave(Color.alpha((int)c0), Color.alpha((int)c1), p -= (float)i);
            int r = this.ave(Color.red((int)c0), Color.red((int)c1), p);
            int g = this.ave(Color.green((int)c0), Color.green((int)c1), p);
            int b = this.ave(Color.blue((int)c0), Color.blue((int)c1), p);
            return Color.argb((int)a, (int)r, (int)g, (int)b);
        }

        private int rotateColor(int color2, float rad) {
            float deg = rad * 180.0f / (float)Math.PI;
            int r = Color.red((int)color2);
            int g = Color.green((int)color2);
            int b = Color.blue((int)color2);
            ColorMatrix cm = new ColorMatrix();
            ColorMatrix tmp = new ColorMatrix();
            cm.setRGB2YUV();
            tmp.setRotate(0, deg);
            cm.postConcat(tmp);
            tmp.setYUV2RGB();
            cm.postConcat(tmp);
            float[] a = cm.getArray();
            int ir = this.floatToByte(a[0] * (float)r + a[1] * (float)g + a[2] * (float)b);
            int ig = this.floatToByte(a[5] * (float)r + a[6] * (float)g + a[7] * (float)b);
            int ib = this.floatToByte(a[10] * (float)r + a[11] * (float)g + a[12] * (float)b);
            return Color.argb((int)Color.alpha((int)color2), (int)this.pinToByte(ir), (int)this.pinToByte(ig), (int)this.pinToByte(ib));
        }

        public boolean onTouchEvent(MotionEvent event) {
            float y;
            float x = event.getX() - 100.0f;
            boolean inCenter = Math.sqrt(x * x + (y = event.getY() - 100.0f) * y) <= 32.0;
            switch (event.getAction()) {
                case 0: {
                    this.mTrackingCenter = inCenter;
                    if (inCenter) {
                        this.mHighlightCenter = true;
                        this.invalidate();
                        break;
                    }
                }
                case 2: {
                    if (this.mTrackingCenter) {
                        if (this.mHighlightCenter == inCenter) break;
                        this.mHighlightCenter = inCenter;
                        this.invalidate();
                        break;
                    }
                    float angle = (float)Math.atan2(y, x);
                    float unit = angle / 6.283185f;
                    if (unit < 0.0f) {
                        unit += 1.0f;
                    }
                    this.mCenterPaint.setColor(this.interpColor(this.mColors, unit));
                    this.invalidate();
                    break;
                }
                case 1: {
                    if (!this.mTrackingCenter) break;
                    if (inCenter) {
                        this.mListener.colorChanged(this.mCenterPaint.getColor());
                    }
                    this.mTrackingCenter = false;
                    this.invalidate();
                }
            }
            return true;
        }
    }

    public static interface OnColorChangedListener {
        public void colorChanged(int var1);
    }
}

