/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Vibrator;
import android.preference.PreferenceManager;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import javax.annotation.Nonnull;
import org.solovyev.android.view.AndroidViewUtils;
import org.solovyev.android.view.OnClickListenerVibrator;
import org.solovyev.android.view.R;
import org.solovyev.common.math.Point2d;
import org.solovyev.common.text.Strings;

public class ColorButton
extends Button {
    private int magicFlameColour;
    private boolean drawMagicFlame = true;
    private static final int CLICK_FEEDBACK_INTERVAL = 10;
    private static final int CLICK_FEEDBACK_DURATION = 350;
    @Nonnull
    private Point2d textPosition;
    private long animationStart;
    private Paint feedbackPaint;
    @Nonnull
    private final OnClickListenerVibrator onClickListener;
    private static final float H_TEXT_POSITION_DEFAULT_VALUE = 0.5f;
    private float hTextPosition = 0.5f;
    private boolean showText = true;

    public ColorButton(Context context, AttributeSet attrs) {
        this(context, attrs, true);
    }

    public ColorButton(Context context, AttributeSet attrs, boolean init) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DragButton);
        this.hTextPosition = a.hasValue(R.styleable.DragButton_hTextPosition) ? Float.valueOf(a.getString(R.styleable.DragButton_hTextPosition)).floatValue() : 0.5f;
        a.recycle();
        if (init) {
            this.init(context);
        }
        this.onClickListener = new OnClickListenerVibrator((Vibrator)context.getSystemService("vibrator"), PreferenceManager.getDefaultSharedPreferences((Context)context));
    }

    protected void init(Context context) {
        Resources resources = this.getResources();
        this.magicFlameColour = resources.getColor(R.color.magic_flame);
        this.feedbackPaint = new Paint();
        this.feedbackPaint.setStyle(Paint.Style.STROKE);
        this.feedbackPaint.setStrokeWidth(2.0f);
        this.getPaint().setColor(this.getCurrentTextColor());
        this.animationStart = -1L;
    }

    public void onSizeChanged(int w, int h, int oldW, int oldH) {
        this.measureText();
    }

    protected void measureText() {
        TextPaint paint = this.getPaint();
        if (this.getText() != null) {
            this.textPosition = this.getTextPosition((Paint)paint, this.getText());
        }
    }

    private Point2d getTextPosition(@Nonnull Paint paint, @Nonnull CharSequence text) {
        if (paint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/ColorButton.getTextPosition must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/ColorButton.getTextPosition must not be null");
        }
        Point2d result = new Point2d();
        result.setX(this.hTextPosition * (float)this.getWidth() - 0.5f * paint.measureText(text.toString()));
        float height = (float)this.getHeight() - paint.ascent() - paint.descent();
        result.setY(height / 2.0f);
        return result;
    }

    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        this.measureText();
    }

    public void drawMagicFlame(int duration, Canvas canvas) {
        int alpha = 255 - 255 * duration / 350;
        int color2 = this.magicFlameColour | alpha << 24;
        this.feedbackPaint.setColor(color2);
        canvas.drawRect(1.0f, 1.0f, (float)(this.getWidth() - 1), (float)(this.getHeight() - 1), this.feedbackPaint);
    }

    public void onDraw(Canvas canvas) {
        CharSequence text;
        if (this.drawMagicFlame && this.animationStart != -1L) {
            int animDuration = (int)(System.currentTimeMillis() - this.animationStart);
            if (animDuration >= 350) {
                this.animationStart = -1L;
            } else {
                this.drawMagicFlame(animDuration, canvas);
                this.postInvalidateDelayed(10L);
            }
        }
        if (!Strings.isEmpty((CharSequence)(text = this.getText())) && this.textPosition != null) {
            if (this.showText) {
                canvas.drawText(text, 0, text.length(), this.textPosition.getX(), this.textPosition.getY(), (Paint)this.getPaint());
            }
        } else {
            AndroidViewUtils.drawDrawables(canvas, (TextView)this);
        }
    }

    public void animateClickFeedback() {
        this.animationStart = System.currentTimeMillis();
        this.invalidate();
    }

    public boolean performClick() {
        this.vibrate();
        return super.performClick();
    }

    public boolean performLongClick() {
        this.vibrate();
        return super.performLongClick();
    }

    private void vibrate() {
        this.onClickListener.onClick((View)this);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.drawMagicFlame) {
            switch (event.getAction()) {
                case 1: {
                    this.animateClickFeedback();
                    break;
                }
                case 0: 
                case 3: {
                    this.invalidate();
                }
            }
        }
        return result;
    }

    public void setDrawMagicFlame(boolean drawMagicFlame) {
        this.drawMagicFlame = drawMagicFlame;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
    }
}

