/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.content.Context;
import android.graphics.Canvas;
import android.text.Editable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.TextView;

public class AutoResizeTextView
extends TextView {
    public static final float MIN_TEXT_SIZE = 20.0f;
    private float initialTextSize = 100.0f;
    private static final Canvas textResizeCanvas = new Canvas();
    private static final String ellipsis = "...";
    private OnTextResizeListener textResizeListener;
    private boolean needsResize = false;
    private float minTextSize = 20.0f;
    private float spacingMult = 1.0f;
    private float spacingAdd = 0.0f;
    private boolean addEllipsis = true;

    public AutoResizeTextView(Context context) {
        super(context);
    }

    public AutoResizeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AutoResizeTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        this.needsResize = true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (w != oldw || h != oldh) {
            this.needsResize = true;
        }
    }

    public void setOnResizeListener(OnTextResizeListener listener) {
        this.textResizeListener = listener;
    }

    public void setTextSize(int unit, float size) {
        super.setTextSize(unit, size);
    }

    public void setLineSpacing(float add, float mult) {
        super.setLineSpacing(add, mult);
        this.spacingMult = mult;
        this.spacingAdd = add;
    }

    public void setMinTextSize(float minTextSize) {
        this.minTextSize = minTextSize;
        this.requestLayout();
        this.invalidate();
    }

    public float getMinTextSize() {
        return this.minTextSize;
    }

    public void setAddEllipsis(boolean addEllipsis) {
        this.addEllipsis = addEllipsis;
    }

    public boolean getAddEllipsis() {
        return this.addEllipsis;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (changed || this.needsResize) {
            int widthLimit = right - left - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
            int heightLimit = bottom - top - this.getCompoundPaddingBottom() - this.getCompoundPaddingTop();
            this.resizeText(widthLimit, heightLimit, this.getText());
        }
        super.onLayout(changed, left, top, right, bottom);
    }

    public void resizeText() {
        this.resizeText(this.getText());
    }

    private void resizeText(CharSequence text) {
        int heightLimit = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        int widthLimit = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        this.resizeText(widthLimit, heightLimit, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeText(int width, int height, CharSequence text) {
        int newTextHeight;
        float newTextSize;
        float oldTextSize;
        TextPaint textPaint;
        block14: {
            Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("Resizing: w=" + width + ", h=" + height + ", text='" + text + "'"));
            if (text == null || text.length() == 0 || height <= 0 || width <= 0) {
                return;
            }
            textPaint = this.getPaint();
            oldTextSize = textPaint.getTextSize();
            Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("Old text size: " + oldTextSize));
            newTextSize = this.initialTextSize + 2.0f;
            if (text instanceof Editable) {
                ((Editable)text).append((CharSequence)"|");
            }
            try {
                newTextHeight = this.getTextRect(text, textPaint, width, newTextSize);
                this.logDimensions(newTextSize, newTextHeight);
                if (newTextHeight > height) {
                    while (newTextHeight > height) {
                        if (newTextSize <= this.minTextSize) {
                            break block14;
                        }
                        newTextSize = Math.max(newTextSize - 1.0f, this.minTextSize);
                        newTextHeight = this.getTextRect(text, textPaint, width, newTextSize);
                        this.logDimensions(newTextSize, newTextHeight);
                    }
                    break block14;
                }
                while (newTextHeight < height) {
                    if (newTextSize <= this.minTextSize) {
                        break;
                    }
                    newTextSize = Math.max(newTextSize + 1.0f, this.minTextSize);
                    newTextHeight = this.getTextRect(text, textPaint, width, newTextSize);
                    this.logDimensions(newTextSize, newTextHeight);
                }
            }
            finally {
                if (text instanceof Editable) {
                    ((Editable)text).delete(text.length() - 1, text.length());
                }
            }
        }
        this.initialTextSize = newTextSize;
        if (this.addEllipsis && newTextSize == this.minTextSize && newTextHeight > height) {
            StaticLayout layout2 = new StaticLayout(text, textPaint, width, Layout.Alignment.ALIGN_NORMAL, this.spacingMult, this.spacingAdd, false);
            layout2.draw(textResizeCanvas);
            int lastLine = layout2.getLineForVertical(height) - 1;
            int start = layout2.getLineStart(lastLine);
            int end = layout2.getLineEnd(lastLine);
            float lineWidth = layout2.getLineWidth(lastLine);
            float ellipseWidth = textPaint.measureText(ellipsis);
            while ((float)width < lineWidth + ellipseWidth) {
                lineWidth = textPaint.measureText(text.subSequence(start, --end + 1).toString());
            }
            this.setText(text.subSequence(0, end) + ellipsis);
        }
        textPaint.setTextSize(newTextSize);
        this.setLineSpacing(this.spacingAdd, this.spacingMult);
        if (this.textResizeListener != null) {
            this.textResizeListener.onTextResize(this, oldTextSize, newTextSize);
        }
        this.needsResize = false;
    }

    private void logDimensions(float newTextSize, int newTextHeight) {
        Log.d((String)((Object)((Object)this)).getClass().getName(), (String)("Nex text size: " + newTextSize + ", new text height: " + newTextHeight));
    }

    private int getTextRect(CharSequence source, TextPaint paint, int width, float textSize) {
        paint.setTextSize(textSize);
        StaticLayout layout2 = new StaticLayout(source, paint, width, Layout.Alignment.ALIGN_NORMAL, this.spacingMult, this.spacingAdd, false);
        layout2.draw(textResizeCanvas);
        return layout2.getHeight();
    }

    public static interface OnTextResizeListener {
        public void onTextResize(TextView var1, float var2, float var3);
    }
}

