/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.TextView;
import javax.annotation.Nonnull;
import org.solovyev.android.view.ButtonDef;
import org.solovyev.android.view.ViewDef;

public final class AndroidViewUtils {
    private AndroidViewUtils() {
        throw new AssertionError();
    }

    public static boolean drawDrawables(Canvas canvas, @Nonnull TextView textView) {
        if (textView == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/AndroidViewUtils.drawDrawables must not be null");
        }
        int compoundPaddingLeft = textView.getCompoundPaddingLeft();
        int compoundPaddingTop = textView.getCompoundPaddingTop();
        int compoundPaddingRight = textView.getCompoundPaddingRight();
        int compoundPaddingBottom = textView.getCompoundPaddingBottom();
        int scrollX = textView.getScrollX();
        int scrollY = textView.getScrollY();
        int right = textView.getRight();
        int left = textView.getLeft();
        int bottom = textView.getBottom();
        int top = textView.getTop();
        Drawable[] drawables = textView.getCompoundDrawables();
        if (drawables != null) {
            int vspace = bottom - top - compoundPaddingBottom - compoundPaddingTop;
            int hspace = right - left - compoundPaddingRight - compoundPaddingLeft;
            Drawable topDr = drawables[1];
            if (topDr != null) {
                canvas.save();
                canvas.translate((float)(scrollX + compoundPaddingLeft + (hspace - topDr.getBounds().width()) / 2), (float)(scrollY + textView.getPaddingTop() + vspace / 2));
                topDr.draw(canvas);
                canvas.restore();
                return true;
            }
        }
        return false;
    }

    public static void applyButtonDef(@Nonnull Button button, @Nonnull ButtonDef buttonDef) {
        if (button == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/AndroidViewUtils.applyButtonDef must not be null");
        }
        if (buttonDef == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/AndroidViewUtils.applyButtonDef must not be null");
        }
        button.setText(buttonDef.getText());
        Integer drawableResId = buttonDef.getDrawableResId();
        if (drawableResId != null) {
            button.setPadding(0, 0, 0, 0);
            Drawable drawable2 = button.getContext().getResources().getDrawable(drawableResId.intValue());
            button.setCompoundDrawablesWithIntrinsicBounds(null, drawable2, null, null);
            button.setCompoundDrawablePadding(0);
        }
        AndroidViewUtils.applyViewDef((View)button, buttonDef);
    }

    public static void applyButtonDef(@Nonnull ImageButton imageButton, @Nonnull ButtonDef buttonDef) {
        if (imageButton == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/AndroidViewUtils.applyButtonDef must not be null");
        }
        if (buttonDef == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/AndroidViewUtils.applyButtonDef must not be null");
        }
        Integer drawableResId = buttonDef.getDrawableResId();
        if (drawableResId != null) {
            imageButton.setImageDrawable(imageButton.getContext().getResources().getDrawable(drawableResId.intValue()));
        }
        AndroidViewUtils.applyViewDef((View)imageButton, buttonDef);
    }

    public static void applyViewDef(@Nonnull View view, @Nonnull ViewDef viewDef) {
        String tag;
        if (view == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/AndroidViewUtils.applyViewDef must not be null");
        }
        if (viewDef == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/AndroidViewUtils.applyViewDef must not be null");
        }
        Integer backgroundResId = viewDef.getBackgroundResId();
        if (backgroundResId != null) {
            view.setBackgroundResource(backgroundResId.intValue());
        }
        if ((tag = viewDef.getTag()) != null) {
            view.setTag((Object)tag);
        }
    }
}

