/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.R;
import org.solovyev.common.Converter;
import org.solovyev.common.math.LinearNormalizer;
import org.solovyev.common.math.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRangeSeekBar<T>
extends ImageView {
    @Nonnull
    private final Paint paint;
    @Nonnull
    private final ThumbContainer tc;
    @Nonnull
    private final Converter<T, Double> toDoubleConverter;
    @Nonnull
    private final Converter<Double, T> toTConverter;
    @Nonnull
    private final T minValue;
    @Nonnull
    private final T maxValue;
    @Nonnull
    private final Normalizer fromValueNormalizer;
    @Nonnull
    private final Normalizer fromScreenNormalizer;
    private double normalizedMinValue;
    private double normalizedMaxValue;
    private Thumb pressedThumb;
    private boolean notifyWhileDragging;
    @Nullable
    private OnRangeSeekBarChangeListener<T> listener;

    public AbstractRangeSeekBar(@Nonnull T minValue, @Nonnull T maxValue, @Nullable Integer steps, Context context) throws IllegalArgumentException {
        if (minValue == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/AbstractRangeSeekBar.<init> must not be null");
        }
        if (maxValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/view/AbstractRangeSeekBar.<init> must not be null");
        }
        super(context);
        this.paint = new Paint();
        this.normalizedMinValue = 0.0;
        this.normalizedMaxValue = 1.0;
        this.pressedThumb = null;
        this.notifyWhileDragging = false;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.toDoubleConverter = this.getToDoubleConverter();
        this.toTConverter = this.getToTConverter();
        this.fromValueNormalizer = new LinearNormalizer(((Double)this.toDoubleConverter.convert(minValue)).doubleValue(), ((Double)this.toDoubleConverter.convert(maxValue)).doubleValue());
        this.tc = new ThumbContainer();
        this.fromScreenNormalizer = new Normalizer(){

            public double normalize(double value) {
                int width = AbstractRangeSeekBar.this.getWidth();
                if ((float)width <= 2.0f * AbstractRangeSeekBar.this.tc.padding) {
                    return 0.0;
                }
                double result = (value - (double)AbstractRangeSeekBar.this.tc.padding) / (double)((float)width - 2.0f * AbstractRangeSeekBar.this.tc.padding);
                return Math.min(1.0, Math.max(0.0, result));
            }

            public double denormalize(double value) {
                return (float)((double)AbstractRangeSeekBar.this.tc.padding + value * (double)((float)AbstractRangeSeekBar.this.getWidth() - 2.0f * AbstractRangeSeekBar.this.tc.padding));
            }
        };
    }

    @Nonnull
    protected abstract Converter<Double, T> getToTConverter();

    @Nonnull
    protected abstract Converter<T, Double> getToDoubleConverter();

    public boolean isNotifyWhileDragging() {
        return this.notifyWhileDragging;
    }

    public void setNotifyWhileDragging(boolean flag) {
        this.notifyWhileDragging = flag;
    }

    @Nonnull
    public T getMinValue() {
        T t = this.minValue;
        if (t == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/AbstractRangeSeekBar.getMinValue must not return null");
        }
        return t;
    }

    @Nonnull
    public T getMaxValue() {
        T t = this.maxValue;
        if (t == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/view/AbstractRangeSeekBar.getMaxValue must not return null");
        }
        return t;
    }

    public T getSelectedMinValue() {
        return this.denormalizeValue(this.normalizedMinValue);
    }

    public void setSelectedMinValue(@Nonnull T value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/AbstractRangeSeekBar.setSelectedMinValue must not be null");
        }
        this.setNormalizedMinValue(this.normalizeValue(value));
    }

    public T getSelectedMaxValue() {
        return this.denormalizeValue(this.normalizedMaxValue);
    }

    public void setSelectedMaxValue(@Nonnull T value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/view/AbstractRangeSeekBar.setSelectedMaxValue must not be null");
        }
        this.setNormalizedMaxValue(this.normalizeValue(value));
    }

    public void setOnRangeSeekBarChangeListener(OnRangeSeekBarChangeListener<T> listener) {
        this.listener = listener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.pressedThumb = this.evalPressedThumb(event.getX());
                this.invalidate();
                break;
            }
            case 2: {
                if (this.pressedThumb == null) break;
                double value = this.convertToNormalizedValue(event.getX());
                if (Thumb.MIN.equals((Object)this.pressedThumb)) {
                    this.setNormalizedMinValue(value);
                } else if (Thumb.MAX.equals((Object)this.pressedThumb)) {
                    this.setNormalizedMaxValue(value);
                }
                if (!this.notifyWhileDragging || this.listener == null) break;
                this.listener.rangeSeekBarValuesChanged(this.getSelectedMinValue(), this.getSelectedMaxValue(), false);
                break;
            }
            case 1: 
            case 3: {
                this.pressedThumb = null;
                this.invalidate();
                if (this.listener == null) break;
                this.listener.rangeSeekBarValuesChanged(this.getSelectedMinValue(), this.getSelectedMaxValue(), true);
            }
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = 200;
        if (0 != View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        }
        int height = this.tc.thumbImage.getHeight();
        if (0 != View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            height = Math.min(height, View.MeasureSpec.getSize((int)heightMeasureSpec));
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        RectF rect = this.tc.getRect();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(-7829368);
        canvas.drawRect(rect, this.paint);
        rect.left = this.convertToScreenValue(this.normalizedMinValue);
        rect.right = this.convertToScreenValue(this.normalizedMaxValue);
        this.paint.setColor(Color.rgb((int)255, (int)165, (int)0));
        canvas.drawRect(rect, this.paint);
        this.drawThumb(this.convertToScreenValue(this.normalizedMinValue), Thumb.MIN == this.pressedThumb, canvas);
        this.drawThumb(this.convertToScreenValue(this.normalizedMaxValue), Thumb.MAX == this.pressedThumb, canvas);
    }

    private void drawThumb(float normalizedToScreenValue, boolean pressed, Canvas canvas) {
        canvas.drawBitmap(this.tc.getImage(pressed), normalizedToScreenValue - this.tc.thumbHalfWidth, 0.5f * (float)this.getHeight() - this.tc.thumbHalfHeight, this.paint);
    }

    private Thumb evalPressedThumb(float touchX) {
        Thumb result = null;
        boolean minThumbPressed = this.isInThumbRange(touchX, this.normalizedMinValue);
        boolean maxThumbPressed = this.isInThumbRange(touchX, this.normalizedMaxValue);
        if (minThumbPressed && maxThumbPressed) {
            result = touchX / (float)this.getWidth() > 0.5f ? Thumb.MIN : Thumb.MAX;
        } else if (minThumbPressed) {
            result = Thumb.MIN;
        } else if (maxThumbPressed) {
            result = Thumb.MAX;
        }
        return result;
    }

    private boolean isInThumbRange(float touchX, double normalizedThumbValue) {
        return Math.abs(touchX - this.convertToScreenValue(normalizedThumbValue)) <= this.tc.thumbHalfWidth;
    }

    private void setNormalizedMinValue(double value) {
        this.normalizedMinValue = Math.max(0.0, Math.min(1.0, Math.min(value, this.normalizedMaxValue)));
        this.invalidate();
    }

    private void setNormalizedMaxValue(double value) {
        this.normalizedMaxValue = Math.max(0.0, Math.min(1.0, Math.max(value, this.normalizedMinValue)));
        this.invalidate();
    }

    private T denormalizeValue(double normalized) {
        return (T)this.toTConverter.convert((Object)this.fromValueNormalizer.denormalize(normalized));
    }

    private double normalizeValue(T value) {
        return this.fromValueNormalizer.normalize(((Double)this.toDoubleConverter.convert(value)).doubleValue());
    }

    private float convertToScreenValue(double normalizedValue) {
        return (float)this.fromScreenNormalizer.denormalize(normalizedValue);
    }

    private double convertToNormalizedValue(float screenValue) {
        return this.fromScreenNormalizer.normalize((double)screenValue);
    }

    private class ThumbContainer {
        @Nonnull
        private final Bitmap thumbImage;
        @Nonnull
        private final Bitmap thumbPressedImage;
        private final float thumbWidth;
        private final float thumbHalfWidth;
        private final float thumbHalfHeight;
        private final float lineHeight;
        private final float padding;

        private ThumbContainer() {
            this.thumbImage = BitmapFactory.decodeResource((Resources)AbstractRangeSeekBar.this.getResources(), (int)R.drawable.seek_thumb_normal);
            this.thumbPressedImage = BitmapFactory.decodeResource((Resources)AbstractRangeSeekBar.this.getResources(), (int)R.drawable.seek_thumb_pressed);
            this.thumbWidth = this.thumbImage.getWidth();
            this.thumbHalfWidth = 0.5f * this.thumbWidth;
            this.thumbHalfHeight = 0.5f * (float)this.thumbImage.getHeight();
            this.lineHeight = 0.3f * this.thumbHalfHeight;
            this.padding = this.thumbHalfWidth;
        }

        public RectF getRect() {
            return new RectF(this.padding, 0.5f * ((float)AbstractRangeSeekBar.this.getHeight() - this.lineHeight), (float)AbstractRangeSeekBar.this.getWidth() - this.padding, 0.5f * ((float)AbstractRangeSeekBar.this.getHeight() + this.lineHeight));
        }

        public Bitmap getImage(boolean pressed) {
            return pressed ? this.thumbPressedImage : this.thumbImage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Thumb {
        MIN,
        MAX;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OnRangeSeekBarChangeListener<T> {
        public void rangeSeekBarValuesChanged(T var1, T var2, boolean var3);
    }
}

