/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.sherlock;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.app.SherlockFragmentActivity;
import java.util.List;
import javax.annotation.Nonnull;
import org.solovyev.android.list.ListAdapter;
import org.solovyev.android.sherlock.AndroidSherlockUtils;
import org.solovyev.android.sherlock.FragmentItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBarNavigationFragmentListener<T extends Fragment>
implements ActionBar.OnNavigationListener {
    @Nonnull
    private final SherlockFragmentActivity activity;
    @Nonnull
    private List<? extends FragmentItem> items;
    private int selected;
    @Nonnull
    private ListAdapter<String> adapter;

    public ActionBarNavigationFragmentListener(@Nonnull SherlockFragmentActivity activity, @Nonnull List<? extends FragmentItem> items, @Nonnull List<String> itemLabels) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/sherlock/ActionBarNavigationFragmentListener.<init> must not be null");
        }
        if (items == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/sherlock/ActionBarNavigationFragmentListener.<init> must not be null");
        }
        if (itemLabels == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/sherlock/ActionBarNavigationFragmentListener.<init> must not be null");
        }
        this.selected = -1;
        assert (items.size() == itemLabels.size());
        this.activity = activity;
        this.items = items;
        this.adapter = AndroidSherlockUtils.newSherlockDefaultAdapter(activity, itemLabels);
    }

    @Nonnull
    public synchronized ListAdapter getAdapter() {
        ListAdapter<String> listAdapter = this.adapter;
        if (listAdapter == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/sherlock/ActionBarNavigationFragmentListener.getAdapter must not return null");
        }
        return listAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNavigationItemSelected(int itemPosition, long itemId) {
        FragmentManager fragmentManager = this.activity.getSupportFragmentManager();
        FragmentTransaction ft = fragmentManager.beginTransaction();
        try {
            if (this.selected != itemPosition) {
                if (this.selected >= 0 && this.selected < this.items.size()) {
                    this.items.get(this.selected).onUnselected(ft);
                }
                if (itemPosition < this.items.size()) {
                    this.items.get(itemPosition).onSelected(ft);
                    this.selected = itemPosition;
                }
            }
        }
        finally {
            if (ft != null && !ft.isEmpty()) {
                ft.commit();
            }
        }
        return true;
    }
}

