/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.properties;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.properties.AProperty;
import org.solovyev.android.properties.APropertyImpl;
import org.solovyev.android.properties.MutableAProperties;
import org.solovyev.common.JObject;
import org.solovyev.common.clone.Cloneables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MutableAPropertiesImpl
extends JObject
implements MutableAProperties {
    @Nonnull
    private Map<String, AProperty> properties = new HashMap<String, AProperty>();

    @Nonnull
    static MutableAProperties copyOf(@Nonnull MutableAProperties propertiesContainer) {
        if (propertiesContainer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/properties/MutableAPropertiesImpl.copyOf must not be null");
        }
        MutableAProperties mutableAProperties = propertiesContainer.clone();
        if (mutableAProperties == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/properties/MutableAPropertiesImpl.copyOf must not return null");
        }
        return mutableAProperties;
    }

    @Nonnull
    static MutableAProperties newInstance(@Nonnull Collection<AProperty> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/properties/MutableAPropertiesImpl.newInstance must not be null");
        }
        MutableAPropertiesImpl result = new MutableAPropertiesImpl();
        for (AProperty property : properties) {
            result.setProperty(property);
        }
        MutableAPropertiesImpl mutableAPropertiesImpl = result;
        if (mutableAPropertiesImpl == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/properties/MutableAPropertiesImpl.newInstance must not return null");
        }
        return mutableAPropertiesImpl;
    }

    @Nonnull
    static MutableAProperties newInstance(@Nonnull Map<String, AProperty> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/properties/MutableAPropertiesImpl.newInstance must not be null");
        }
        MutableAPropertiesImpl result = new MutableAPropertiesImpl();
        for (AProperty property : properties.values()) {
            result.setProperty(property);
        }
        MutableAPropertiesImpl mutableAPropertiesImpl = result;
        if (mutableAPropertiesImpl == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/properties/MutableAPropertiesImpl.newInstance must not return null");
        }
        return mutableAPropertiesImpl;
    }

    @Override
    @Nonnull
    public MutableAPropertiesImpl clone() {
        MutableAPropertiesImpl clone = (MutableAPropertiesImpl)super.clone();
        clone.properties = Cloneables.cloneMap(this.properties);
        MutableAPropertiesImpl mutableAPropertiesImpl = clone;
        if (mutableAPropertiesImpl == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/properties/MutableAPropertiesImpl.clone must not return null");
        }
        return mutableAPropertiesImpl;
    }

    @Override
    @Nonnull
    public AProperty setProperty(@Nonnull String name, @Nonnull String value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/properties/MutableAPropertiesImpl.setProperty must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/properties/MutableAPropertiesImpl.setProperty must not be null");
        }
        AProperty property = APropertyImpl.newInstance(name, value);
        this.properties.put(name, property);
        AProperty aProperty = property;
        if (aProperty == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/properties/MutableAPropertiesImpl.setProperty must not return null");
        }
        return aProperty;
    }

    @Override
    public void setProperty(@Nonnull AProperty property) {
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/properties/MutableAPropertiesImpl.setProperty must not be null");
        }
        this.properties.put(property.getName(), property);
    }

    @Override
    public void setPropertiesFrom(@Nonnull MutableAProperties that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/properties/MutableAPropertiesImpl.setPropertiesFrom must not be null");
        }
        for (AProperty property : that.getProperties().values()) {
            this.setProperty(property);
        }
    }

    @Override
    public void setPropertiesFrom(@Nonnull Collection<AProperty> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/properties/MutableAPropertiesImpl.setPropertiesFrom must not be null");
        }
        for (AProperty property : properties) {
            this.setProperty(property);
        }
    }

    @Override
    @Nullable
    public AProperty removeProperty(@Nonnull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/properties/MutableAPropertiesImpl.removeProperty must not be null");
        }
        return this.properties.remove(name);
    }

    @Override
    @Nullable
    public AProperty getProperty(@Nonnull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/properties/MutableAPropertiesImpl.getProperty must not be null");
        }
        return this.properties.get(name);
    }

    @Override
    public String getPropertyValue(@Nonnull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/properties/MutableAPropertiesImpl.getPropertyValue must not be null");
        }
        AProperty property = this.properties.get(name);
        return property == null ? null : property.getValue();
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    @Nonnull
    public Map<String, AProperty> getProperties() {
        Map<String, AProperty> map = Collections.unmodifiableMap(this.properties);
        if (map == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/properties/MutableAPropertiesImpl.getProperties must not return null");
        }
        return map;
    }

    @Override
    @Nonnull
    public Collection<AProperty> getPropertiesCollection() {
        Collection<AProperty> collection = Collections.unmodifiableCollection(this.properties.values());
        if (collection == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/properties/MutableAPropertiesImpl.getPropertiesCollection must not return null");
        }
        return collection;
    }
}

