/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.prefs;

import android.content.SharedPreferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.prefs.AbstractPreference;
import org.solovyev.common.text.EnumMapper;
import org.solovyev.common.text.Mapper;
import org.solovyev.common.text.StringMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringPreference<T>
extends AbstractPreference<T> {
    @Nonnull
    private final Mapper<T> mapper;

    public StringPreference(@Nonnull String key, @Nullable T defaultValue, @Nonnull Mapper<T> mapper) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/StringPreference.<init> must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/StringPreference.<init> must not be null");
        }
        super(key, defaultValue);
        this.mapper = mapper;
    }

    @Nonnull
    public static StringPreference<String> of(@Nonnull String key, @Nullable String defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/StringPreference.of must not be null");
        }
        StringPreference<String> stringPreference = new StringPreference<String>(key, defaultValue, StringMapper.getInstance());
        if (stringPreference == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/StringPreference.of must not return null");
        }
        return stringPreference;
    }

    @Nonnull
    public static <T> StringPreference<T> ofTypedValue(@Nonnull String key, @Nullable String defaultValue, @Nonnull Mapper<T> mapper) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/StringPreference.ofTypedValue must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/StringPreference.ofTypedValue must not be null");
        }
        StringPreference<Object> stringPreference = new StringPreference<Object>(key, mapper.parseValue(defaultValue), mapper);
        if (stringPreference == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/StringPreference.ofTypedValue must not return null");
        }
        return stringPreference;
    }

    @Nonnull
    public static <T extends Enum> StringPreference<T> ofEnum(@Nonnull String key, @Nullable T defaultValue, @Nonnull Class<T> enumType) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/StringPreference.ofEnum must not be null");
        }
        if (enumType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/StringPreference.ofEnum must not be null");
        }
        StringPreference<T> stringPreference = new StringPreference<T>(key, defaultValue, EnumMapper.of(enumType));
        if (stringPreference == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/StringPreference.ofEnum must not return null");
        }
        return stringPreference;
    }

    @Override
    protected T getPersistedValue(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/StringPreference.getPersistedValue must not be null");
        }
        return (T)this.mapper.parseValue(preferences.getString(this.getKey(), null));
    }

    @Override
    protected void putPersistedValue(@Nonnull SharedPreferences.Editor editor, @Nonnull T value) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/StringPreference.putPersistedValue must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/prefs/StringPreference.putPersistedValue must not be null");
        }
        editor.putString(this.getKey(), this.mapper.formatValue(value));
    }
}

