/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.prefs;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import javax.annotation.Nonnull;
import org.solovyev.android.prefs.AbstractDialogPreference;
import org.solovyev.common.text.NumberMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeekBarPreference
extends AbstractDialogPreference<Integer>
implements SeekBar.OnSeekBarChangeListener {
    private int max = 0;

    public SeekBarPreference(Context context, AttributeSet attrs) {
        super(context, attrs, "50", true, NumberMapper.of(Integer.class));
        this.max = attrs.getAttributeIntValue("http://schemas.android.com/apk/res/android", "max", 100);
    }

    @Override
    protected LinearLayout.LayoutParams getParams() {
        return new LinearLayout.LayoutParams(-1, -2);
    }

    @Override
    @Nonnull
    protected View createPreferenceView(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/SeekBarPreference.createPreferenceView must not be null");
        }
        SeekBar result = new SeekBar(context);
        result.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        SeekBar seekBar = result;
        if (seekBar == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/SeekBarPreference.createPreferenceView must not return null");
        }
        return seekBar;
    }

    @Override
    protected void initPreferenceView(@Nonnull View v, Integer value) {
        if (v == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/SeekBarPreference.initPreferenceView must not be null");
        }
        ((SeekBar)v).setMax(this.max);
        if (value != null) {
            ((SeekBar)v).setProgress(value.intValue());
            this.setValueText(value);
        }
    }

    public void onProgressChanged(SeekBar seek, int value, boolean fromTouch) {
        this.setValueText(value);
        this.persistValue(value);
    }

    private void setValueText(int value) {
        String t = String.valueOf(value);
        String valueText = this.getValueText();
        this.updateValueText(valueText == null ? t : t.concat(valueText));
    }

    public void onStartTrackingTouch(SeekBar seek) {
    }

    public void onStopTrackingTouch(SeekBar seek) {
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public void setProgress(int progress) {
        this.setValue(progress);
        View preferenceView = this.getPreferenceView();
        if (preferenceView != null) {
            ((SeekBar)preferenceView).setProgress(progress);
        }
    }

    public int getProgress() {
        Integer value = (Integer)this.getValue();
        return value == null ? 0 : value;
    }
}

