/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.prefs;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import javax.annotation.Nonnull;
import org.solovyev.android.prefs.AbstractDialogPreference;
import org.solovyev.android.view.AbstractRangeSeekBar;
import org.solovyev.android.view.NumberRangeSeekBar;
import org.solovyev.common.interval.Interval;
import org.solovyev.common.interval.Intervals;
import org.solovyev.common.text.NumberIntervalMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RangeSeekBarPreference<T extends Number>
extends AbstractDialogPreference<Interval<T>>
implements AbstractRangeSeekBar.OnRangeSeekBarChangeListener<T> {
    @Nonnull
    private final Interval<T> boundaries;
    @Nonnull
    private final T step;

    public RangeSeekBarPreference(@Nonnull Context context, AttributeSet attrs, @Nonnull NumberIntervalMapper<T> mapper) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/RangeSeekBarPreference.<init> must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/RangeSeekBarPreference.<init> must not be null");
        }
        super(context, attrs, (String)null, true, mapper);
        this.boundaries = mapper.parseValue(attrs.getAttributeValue("http://schemas.android.com/apk/res-auto", "boundaries"));
        String stepValue = attrs.getAttributeValue("http://schemas.android.com/apk/res-auto", "step");
        this.step = stepValue == null ? this.getDefaultStep() : (Number)mapper.getMapper().parseValue(stepValue);
    }

    @Nonnull
    protected abstract T getDefaultStep();

    @Override
    @Nonnull
    protected View createPreferenceView(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/RangeSeekBarPreference.createPreferenceView must not be null");
        }
        int count = 0;
        Number t = (Number)((Object)this.boundaries.getLeftLimit());
        while (((Comparable)((Object)t)).compareTo(this.boundaries.getRightLimit()) <= 0) {
            ++count;
            t = this.add(t, this.step);
        }
        NumberRangeSeekBar<T> result = new NumberRangeSeekBar<T>(this.boundaries, count, context);
        result.setNotifyWhileDragging(true);
        result.setOnRangeSeekBarChangeListener(this);
        NumberRangeSeekBar<T> numberRangeSeekBar = result;
        if (numberRangeSeekBar == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/RangeSeekBarPreference.createPreferenceView must not return null");
        }
        return numberRangeSeekBar;
    }

    @Nonnull
    protected abstract T add(@Nonnull T var1, @Nonnull T var2);

    @Override
    protected LinearLayout.LayoutParams getParams() {
        return null;
    }

    @Override
    protected void initPreferenceView(@Nonnull View v, Interval<T> value) {
        if (v == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/RangeSeekBarPreference.initPreferenceView must not be null");
        }
        if (value != null) {
            ((NumberRangeSeekBar)v).setSelectedMinValue(value.getLeftLimit());
            ((NumberRangeSeekBar)v).setSelectedMaxValue(value.getRightLimit());
            this.setValueText(value);
        }
    }

    @Override
    public void rangeSeekBarValuesChanged(T minValue, T maxValue, boolean changeComplete) {
        Interval interval = Intervals.newClosedInterval((Comparable)((Comparable)minValue), (Comparable)((Comparable)maxValue));
        if (changeComplete) {
            this.persistValue(interval);
        }
        this.setValueText(interval);
    }

    private void setValueText(@Nonnull Interval<T> interval) {
        if (interval == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/RangeSeekBarPreference.setValueText must not be null");
        }
        String t = String.valueOf(interval);
        String valueText = this.getValueText();
        this.updateValueText(valueText == null ? t : t.concat(valueText));
    }
}

