/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.prefs;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.preference.ListPreference;
import android.util.AttributeSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.view.R;
import org.solovyev.common.text.Formatter;
import org.solovyev.common.text.Parser;
import org.solovyev.common.text.StringCollections;
import org.solovyev.common.text.StringMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSelectListPreference<T>
extends ListPreference {
    @Nonnull
    private static final String DEFAULT_SEPARATOR = ";";
    @Nonnull
    private final org.solovyev.common.text.Mapper<List<String>> mapper;
    private boolean[] checkedIndices;

    public MultiSelectListPreference(Context context) {
        this(context, null);
    }

    public MultiSelectListPreference(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MultiSelectListPreference);
        String separator = a.hasValue(R.styleable.MultiSelectListPreference_separator) ? a.getString(R.styleable.MultiSelectListPreference_separator) : DEFAULT_SEPARATOR;
        a.recycle();
        this.mapper = new Mapper(separator);
        this.checkedIndices = new boolean[this.getEntries().length];
    }

    public void setEntries(@Nonnull CharSequence[] entries) {
        if (entries == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/MultiSelectListPreference.setEntries must not be null");
        }
        super.setEntries(entries);
        this.checkedIndices = new boolean[entries.length];
    }

    protected void onPrepareDialogBuilder(@Nonnull AlertDialog.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/MultiSelectListPreference.onPrepareDialogBuilder must not be null");
        }
        CharSequence[] entries = this.getEntries();
        CharSequence[] entryValues = this.getEntryValues();
        if (entries == null || entryValues == null || entries.length != entryValues.length) {
            throw new IllegalStateException("ListPreference requires an entries array and an entryValues array which are both the same length");
        }
        this.restoreCheckedEntries();
        builder.setMultiChoiceItems(entries, this.checkedIndices, new DialogInterface.OnMultiChoiceClickListener(){

            public void onClick(DialogInterface dialog, int which, boolean value) {
                ((MultiSelectListPreference)MultiSelectListPreference.this).checkedIndices[which] = value;
            }
        });
    }

    private void restoreCheckedEntries() {
        CharSequence[] entryValues = this.getEntryValues();
        List values = (List)this.mapper.parseValue(this.getValue());
        if (values != null) {
            block0: for (String value : values) {
                for (int i = 0; i < entryValues.length; ++i) {
                    CharSequence entry = entryValues[i];
                    if (!entry.equals(value)) continue;
                    this.checkedIndices[i] = true;
                    continue block0;
                }
            }
        }
    }

    protected void onDialogClosed(boolean positiveResult) {
        CharSequence[] entryValues = this.getEntryValues();
        if (positiveResult && entryValues != null) {
            ArrayList<String> checkedValues = new ArrayList<String>();
            for (int i = 0; i < entryValues.length; ++i) {
                if (!this.checkedIndices[i]) continue;
                checkedValues.add(entryValues[i].toString());
            }
            String value = this.mapper.formatValue(checkedValues);
            if (this.callChangeListener(value)) {
                this.setValue(value);
            }
        }
    }

    @Nonnull
    public static <T> org.solovyev.common.text.Mapper<List<T>> newListMapper(@Nonnull org.solovyev.common.text.Mapper<T> nestedMapper) {
        if (nestedMapper == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/MultiSelectListPreference.newListMapper must not be null");
        }
        ListMapper<T> listMapper = new ListMapper<T>(DEFAULT_SEPARATOR, nestedMapper);
        if (listMapper == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/MultiSelectListPreference.newListMapper must not return null");
        }
        return listMapper;
    }

    @Nonnull
    public static <T> org.solovyev.common.text.Mapper<List<T>> newListMapper(@Nonnull org.solovyev.common.text.Mapper<T> nestedMapper, @Nonnull String separator) {
        if (nestedMapper == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/MultiSelectListPreference.newListMapper must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/prefs/MultiSelectListPreference.newListMapper must not be null");
        }
        ListMapper<T> listMapper = new ListMapper<T>(separator, nestedMapper);
        if (listMapper == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/MultiSelectListPreference.newListMapper must not return null");
        }
        return listMapper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListMapper<T>
    implements org.solovyev.common.text.Mapper<List<T>> {
        @Nonnull
        private final String separator;
        @Nonnull
        private final org.solovyev.common.text.Mapper<T> nestedMapper;

        public ListMapper(@Nonnull String separator, @Nonnull org.solovyev.common.text.Mapper<T> nestedMapper) {
            if (separator == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/MultiSelectListPreference$ListMapper.<init> must not be null");
            }
            if (nestedMapper == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/prefs/MultiSelectListPreference$ListMapper.<init> must not be null");
            }
            this.separator = separator;
            this.nestedMapper = nestedMapper;
        }

        public String formatValue(@Nullable List<T> value) throws IllegalArgumentException {
            return StringCollections.formatValue(value, (String)this.separator, this.nestedMapper);
        }

        public List<T> parseValue(@Nullable String value) throws IllegalArgumentException {
            return StringCollections.split((String)value, (String)this.separator, this.nestedMapper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Mapper
    implements org.solovyev.common.text.Mapper<List<String>> {
        @Nonnull
        private final String separator;

        public Mapper(@Nonnull String separator) {
            if (separator == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/MultiSelectListPreference$Mapper.<init> must not be null");
            }
            this.separator = separator;
        }

        public String formatValue(@Nullable List<String> value) throws IllegalArgumentException {
            return StringCollections.formatValue(value, (String)this.separator, (Formatter)StringMapper.getInstance());
        }

        public List<String> parseValue(@Nullable String value) throws IllegalArgumentException {
            return StringCollections.split((String)value, (String)this.separator, (Parser)StringMapper.getInstance());
        }
    }
}

