/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.prefs;

import android.content.SharedPreferences;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.prefs.AbstractPreference;
import org.solovyev.common.text.ListMapper;
import org.solovyev.common.text.Mapper;
import org.solovyev.common.text.StringMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionToStringPreference<C extends Collection<T>, T>
extends AbstractPreference<C> {
    @Nonnull
    private final Mapper<C> mapper;

    private CollectionToStringPreference(@Nonnull String key, @Nullable C defaultValue, @Nonnull Mapper<C> mapper) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/CollectionToStringPreference.<init> must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/CollectionToStringPreference.<init> must not be null");
        }
        super(key, defaultValue);
        this.mapper = mapper;
    }

    @Nonnull
    public static <T> CollectionToStringPreference<List<T>, T> forList(@Nonnull String key, @Nullable List<T> defaultValue, @Nonnull Mapper<List<T>> mapper) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/CollectionToStringPreference.forList must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/CollectionToStringPreference.forList must not be null");
        }
        CollectionToStringPreference<List<T>, T> collectionToStringPreference = new CollectionToStringPreference<List<T>, T>(key, defaultValue, mapper);
        if (collectionToStringPreference == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/CollectionToStringPreference.forList must not return null");
        }
        return collectionToStringPreference;
    }

    @Nonnull
    public static <T> CollectionToStringPreference<List<T>, T> forTypedList(@Nonnull String key, @Nullable List<T> defaultValue, @Nonnull Mapper<T> mapper) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/CollectionToStringPreference.forTypedList must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/CollectionToStringPreference.forTypedList must not be null");
        }
        CollectionToStringPreference<List<T>, T> collectionToStringPreference = new CollectionToStringPreference<List<T>, T>(key, defaultValue, ListMapper.newInstance(mapper));
        if (collectionToStringPreference == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/CollectionToStringPreference.forTypedList must not return null");
        }
        return collectionToStringPreference;
    }

    @Nonnull
    public static CollectionToStringPreference<List<String>, String> forStringList(@Nonnull String key, @Nullable List<String> defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/CollectionToStringPreference.forStringList must not be null");
        }
        CollectionToStringPreference<List<String>, String> collectionToStringPreference = new CollectionToStringPreference<List<String>, String>(key, defaultValue, (Mapper<List<String>>)ListMapper.newInstance((Mapper)StringMapper.getInstance()));
        if (collectionToStringPreference == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/prefs/CollectionToStringPreference.forStringList must not return null");
        }
        return collectionToStringPreference;
    }

    @Override
    protected C getPersistedValue(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/CollectionToStringPreference.getPersistedValue must not be null");
        }
        return (C)((Collection)this.mapper.parseValue(preferences.getString(this.getKey(), null)));
    }

    @Override
    protected void putPersistedValue(@Nonnull SharedPreferences.Editor editor, @Nonnull C values) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/CollectionToStringPreference.putPersistedValue must not be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/prefs/CollectionToStringPreference.putPersistedValue must not be null");
        }
        editor.putString(this.getKey(), this.mapper.formatValue(values));
    }
}

