/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.prefs;

import android.content.SharedPreferences;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.solovyev.android.prefs.AbstractPreference;
import org.solovyev.common.text.Mapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionSetPreference<C extends Collection<T>, T>
extends AbstractPreference<C> {
    @Nonnull
    private final Mapper<T> mapper;

    protected CollectionSetPreference(@Nonnull String id2, @Nonnull C defaultValue, @Nonnull Mapper<T> mapper) {
        if (id2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/CollectionSetPreference.<init> must not be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/prefs/CollectionSetPreference.<init> must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/prefs/CollectionSetPreference.<init> must not be null");
        }
        super(id2, defaultValue);
        this.mapper = mapper;
    }

    @Override
    protected C getPersistedValue(@Nonnull SharedPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/CollectionSetPreference.getPersistedValue must not be null");
        }
        Set stringValues = preferences.getStringSet(this.getKey(), null);
        C result = this.createCollection(stringValues.size());
        for (String stringValue : stringValues) {
            result.add((Object)this.mapper.parseValue(stringValue));
        }
        return result;
    }

    @Nonnull
    protected abstract C createCollection(int var1);

    @Override
    protected void putPersistedValue(@Nonnull SharedPreferences.Editor editor, @Nonnull C values) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/prefs/CollectionSetPreference.putPersistedValue must not be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/prefs/CollectionSetPreference.putPersistedValue must not be null");
        }
        HashSet<String> result = new HashSet<String>(values.size());
        for (Object value : values) {
            result.add(this.mapper.formatValue(value));
        }
        editor.putStringSet(this.getKey(), result);
    }
}

