/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.menu;

import android.app.Activity;
import android.content.Context;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.menu.AMenuItem;
import org.solovyev.android.menu.IdentifiableMenuItem;
import org.solovyev.android.menu.LabeledMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MenuItemWrapper<MI> {
    @Nullable
    private final LabeledMenuItem<MI> labeledMenuItem;
    @Nullable
    private Integer menuItemId;
    @Nullable
    private final IdentifiableMenuItem<MI> identifiableMenuItem;

    MenuItemWrapper(@Nonnull LabeledMenuItem<MI> labeledMenuItem) {
        if (labeledMenuItem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/MenuItemWrapper.<init> must not be null");
        }
        this.labeledMenuItem = labeledMenuItem;
        this.identifiableMenuItem = null;
    }

    MenuItemWrapper(@Nonnull IdentifiableMenuItem<MI> identifiableMenuItem) {
        if (identifiableMenuItem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/MenuItemWrapper.<init> must not be null");
        }
        this.identifiableMenuItem = identifiableMenuItem;
        this.labeledMenuItem = null;
    }

    @Nonnull
    public AMenuItem<MI> getMenuItem() {
        AMenuItem<MI> aMenuItem = this.labeledMenuItem != null ? this.labeledMenuItem : this.identifiableMenuItem;
        if (aMenuItem == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/MenuItemWrapper.getMenuItem must not return null");
        }
        return aMenuItem;
    }

    @Nullable
    public Integer getMenuItemId() {
        return this.identifiableMenuItem == null ? this.menuItemId : this.identifiableMenuItem.getItemId();
    }

    public void setMenuItemId(@Nullable Integer menuItemId) {
        assert (this.labeledMenuItem != null);
        this.menuItemId = menuItemId;
    }

    @Nonnull
    public String getCaption(@Nonnull Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/MenuItemWrapper.getCaption must not be null");
        }
        assert (this.labeledMenuItem != null);
        String string2 = this.labeledMenuItem.getCaption((Context)activity);
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/MenuItemWrapper.getCaption must not return null");
        }
        return string2;
    }
}

