/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.menu;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.menu.ContextMenu;
import org.solovyev.android.menu.LabeledMenuItem;
import org.solovyev.common.collections.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListContextMenu<T extends LabeledMenuItem<D>, D>
implements ContextMenu<T, D> {
    private final List<? extends T> menuItems;

    @Nonnull
    public static <T extends LabeledMenuItem<D>, D> ContextMenu<T, D> newInstance(T ... menuItems) {
        ListContextMenu listContextMenu = new ListContextMenu(menuItems);
        if (listContextMenu == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListContextMenu.newInstance must not return null");
        }
        return listContextMenu;
    }

    @Nonnull
    public static <T extends LabeledMenuItem<D>, D> ContextMenu<T, D> newInstance(@Nonnull List<? extends T> menuItems) {
        if (menuItems == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListContextMenu.newInstance must not be null");
        }
        ListContextMenu<? extends T, D> listContextMenu = new ListContextMenu<T, D>(menuItems);
        if (listContextMenu == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListContextMenu.newInstance must not return null");
        }
        return listContextMenu;
    }

    private ListContextMenu(T ... menuItems) {
        this(Collections.asList((Object[])menuItems));
    }

    private ListContextMenu(@Nonnull List<? extends T> menuItems) {
        if (menuItems == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListContextMenu.<init> must not be null");
        }
        this.menuItems = new ArrayList<T>(menuItems);
    }

    @Override
    @Nullable
    public T itemAt(int i) {
        if (i >= 0 && i < this.menuItems.size()) {
            return (T)((LabeledMenuItem)this.menuItems.get(i));
        }
        return null;
    }

    @Override
    @Nonnull
    public CharSequence[] getMenuCaptions(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListContextMenu.getMenuCaptions must not be null");
        }
        CharSequence[] result = new CharSequence[this.menuItems.size()];
        for (int i = 0; i < this.menuItems.size(); ++i) {
            result[i] = ((LabeledMenuItem)this.menuItems.get(i)).getCaption(context);
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListContextMenu.getMenuCaptions must not return null");
        }
        return result;
    }
}

