/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.menu;

import android.app.Activity;
import android.content.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.menu.AMenuItem;
import org.solovyev.android.menu.ActivityMenu;
import org.solovyev.android.menu.IdentifiableMenuItem;
import org.solovyev.android.menu.LabeledMenuItem;
import org.solovyev.android.menu.MenuHelper;
import org.solovyev.android.menu.MenuItemWrapper;
import org.solovyev.common.JPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListActivityMenu<M, MI>
implements ActivityMenu<M, MI> {
    private static final int NO_MENU_RES_ID = -1;
    @Nonnull
    private final List<MenuItemWrapper<MI>> menuItems;
    private final int menuResId;
    @Nullable
    private final JPredicate<AMenuItem<MI>> filter;
    @Nonnull
    private final MenuHelper<M, MI> menuHelper;

    private ListActivityMenu(@Nullable JPredicate<AMenuItem<MI>> filter, @Nonnull MenuHelper<M, MI> menuHelper) {
        if (menuHelper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.<init> must not be null");
        }
        this(-1, filter, menuHelper);
    }

    private ListActivityMenu(int menuResId, @Nullable JPredicate<AMenuItem<MI>> filter, @Nonnull MenuHelper<M, MI> menuHelper) {
        if (menuHelper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.<init> must not be null");
        }
        this.menuItems = new ArrayList<MenuItemWrapper<MI>>();
        this.menuResId = menuResId;
        this.filter = filter;
        this.menuHelper = menuHelper;
    }

    @Nonnull
    public static <M, MI> ActivityMenu<M, MI> fromList(@Nonnull List<? extends LabeledMenuItem<MI>> menuItems, @Nonnull MenuHelper<M, MI> menuHelper) {
        if (menuItems == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromList must not be null");
        }
        if (menuHelper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromList must not be null");
        }
        ListActivityMenu<M, MI> result = new ListActivityMenu<M, MI>(null, menuHelper);
        for (LabeledMenuItem<MI> menuItem : menuItems) {
            result.menuItems.add(new MenuItemWrapper<MI>(menuItem));
        }
        ListActivityMenu<M, MI> listActivityMenu = result;
        if (listActivityMenu == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListActivityMenu.fromList must not return null");
        }
        return listActivityMenu;
    }

    @Nonnull
    public static <M, MI> ActivityMenu<M, MI> fromList(@Nonnull List<? extends LabeledMenuItem<MI>> menuItems, @Nonnull MenuHelper<M, MI> menuHelper, @Nonnull JPredicate<AMenuItem<MI>> filter) {
        if (menuItems == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromList must not be null");
        }
        if (menuHelper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromList must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromList must not be null");
        }
        ListActivityMenu<M, MI> result = new ListActivityMenu<M, MI>(filter, menuHelper);
        for (LabeledMenuItem<MI> menuItem : menuItems) {
            result.menuItems.add(new MenuItemWrapper<MI>(menuItem));
        }
        ListActivityMenu<M, MI> listActivityMenu = result;
        if (listActivityMenu == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListActivityMenu.fromList must not return null");
        }
        return listActivityMenu;
    }

    @Nonnull
    public static <M, MI, E extends Enum> ActivityMenu<M, MI> fromEnum(@Nonnull Class<E> enumMenuClass, @Nonnull MenuHelper<M, MI> menuHelper, @Nonnull JPredicate<AMenuItem<MI>> filter) {
        if (enumMenuClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromEnum must not be null");
        }
        if (menuHelper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromEnum must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromEnum must not be null");
        }
        ActivityMenu<M, MI> activityMenu = ListActivityMenu.fromList(ListActivityMenu.toList(enumMenuClass), menuHelper, filter);
        if (activityMenu == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListActivityMenu.fromEnum must not return null");
        }
        return activityMenu;
    }

    @Nonnull
    public static <M, MI, E extends Enum> ActivityMenu<M, MI> fromEnum(@Nonnull Class<E> enumMenuClass, @Nonnull MenuHelper<M, MI> menuHelper) {
        if (enumMenuClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromEnum must not be null");
        }
        if (menuHelper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromEnum must not be null");
        }
        ActivityMenu<M, MI> activityMenu = ListActivityMenu.fromList(ListActivityMenu.toList(enumMenuClass), menuHelper);
        if (activityMenu == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListActivityMenu.fromEnum must not return null");
        }
        return activityMenu;
    }

    @Nonnull
    public static <M, MI> ActivityMenu<M, MI> fromResource(int menuResId, @Nonnull List<? extends IdentifiableMenuItem<MI>> menuItems, @Nonnull MenuHelper<M, MI> menuHelper, @Nonnull JPredicate<AMenuItem<MI>> filter) {
        if (menuItems == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromResource must not be null");
        }
        if (menuHelper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromResource must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromResource must not be null");
        }
        ListActivityMenu<M, MI> result = new ListActivityMenu<M, MI>(menuResId, filter, menuHelper);
        for (IdentifiableMenuItem<MI> menuItem : menuItems) {
            result.menuItems.add(new MenuItemWrapper<MI>(menuItem));
        }
        ListActivityMenu<M, MI> listActivityMenu = result;
        if (listActivityMenu == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListActivityMenu.fromResource must not return null");
        }
        return listActivityMenu;
    }

    @Nonnull
    public static <M, MI> ListActivityMenu<M, MI> fromResource(int menuResId, @Nonnull List<? extends IdentifiableMenuItem<MI>> menuItems, @Nonnull MenuHelper<M, MI> menuHelper) {
        if (menuItems == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromResource must not be null");
        }
        if (menuHelper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromResource must not be null");
        }
        ListActivityMenu<M, MI> result = new ListActivityMenu<M, MI>(menuResId, null, menuHelper);
        for (IdentifiableMenuItem<MI> menuItem : menuItems) {
            result.menuItems.add(new MenuItemWrapper<MI>(menuItem));
        }
        ListActivityMenu<M, MI> listActivityMenu = result;
        if (listActivityMenu == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListActivityMenu.fromResource must not return null");
        }
        return listActivityMenu;
    }

    @Nonnull
    public static <M, MI, E extends Enum> ActivityMenu<M, MI> fromResource(int menuResId, @Nonnull Class<? extends E> enumMenuClass, @Nonnull MenuHelper<M, MI> menuHelper, @Nonnull JPredicate<AMenuItem<MI>> filter) {
        if (enumMenuClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromResource must not be null");
        }
        if (menuHelper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromResource must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromResource must not be null");
        }
        ActivityMenu<M, MI> activityMenu = ListActivityMenu.fromResource(menuResId, ListActivityMenu.toList(enumMenuClass), menuHelper, filter);
        if (activityMenu == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListActivityMenu.fromResource must not return null");
        }
        return activityMenu;
    }

    @Nonnull
    public static <M, MI, E extends Enum> ActivityMenu<M, MI> fromResource(int menuResId, @Nonnull Class<? extends E> enumMenuClass, @Nonnull MenuHelper<M, MI> menuHelper) {
        if (enumMenuClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromResource must not be null");
        }
        if (menuHelper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.fromResource must not be null");
        }
        ListActivityMenu<M, MI> listActivityMenu = ListActivityMenu.fromResource(menuResId, ListActivityMenu.toList(enumMenuClass), menuHelper);
        if (listActivityMenu == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListActivityMenu.fromResource must not return null");
        }
        return listActivityMenu;
    }

    @Nonnull
    private static <E extends Enum> List<E> toList(@Nonnull Class<E> enumMenuClass) {
        if (enumMenuClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.toList must not be null");
        }
        ArrayList result = new ArrayList();
        Collections.addAll(result, enumMenuClass.getEnumConstants());
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ListActivityMenu.toList must not return null");
        }
        return arrayList;
    }

    @Override
    public boolean onCreateOptionsMenu(@Nonnull Activity activity, @Nonnull M menu) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.onCreateOptionsMenu must not be null");
        }
        if (menu == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.onCreateOptionsMenu must not be null");
        }
        if (this.filter == null) {
            if (this.isFromMenuRes()) {
                this.menuHelper.inflateMenu(activity, this.menuResId, menu);
            } else {
                for (MenuItemWrapper<MI> menuItem : this.menuItems) {
                    this.addMenuItem(activity, menu, menuItem);
                }
            }
        }
        return true;
    }

    private boolean isFromMenuRes() {
        return this.menuResId != -1;
    }

    private void addMenuItem(@Nonnull Activity activity, @Nonnull M menu, @Nonnull MenuItemWrapper<MI> menuItemWrapper) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.addMenuItem must not be null");
        }
        if (menu == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.addMenuItem must not be null");
        }
        if (menuItemWrapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.addMenuItem must not be null");
        }
        int size = this.menuHelper.size(menu);
        int menuItemId = size + 1;
        MI aMenuItem = this.menuHelper.add(menu, 0, menuItemId, 0, menuItemWrapper.getCaption(activity));
        menuItemWrapper.setMenuItemId(menuItemId);
        this.menuHelper.setOnMenuItemClickListener(aMenuItem, menuItemWrapper.getMenuItem(), activity);
    }

    @Override
    public boolean onPrepareOptionsMenu(@Nonnull Activity activity, @Nonnull M menu) {
        block8: {
            if (activity == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.onPrepareOptionsMenu must not be null");
            }
            if (menu == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.onPrepareOptionsMenu must not be null");
            }
            if (this.filter == null) break block8;
            if (this.isFromMenuRes()) {
                for (MenuItemWrapper<MI> menuItemWrapper : this.menuItems) {
                    Integer menuItemId = menuItemWrapper.getMenuItemId();
                    if (menuItemId == null) continue;
                    this.menuHelper.removeItem(menu, menuItemId);
                }
                this.menuHelper.inflateMenu(activity, this.menuResId, menu);
                for (MenuItemWrapper<MI> menuItemWrapper : this.menuItems) {
                    if (!this.filter.apply(menuItemWrapper.getMenuItem())) continue;
                    this.menuHelper.removeItem(menu, menuItemWrapper.getMenuItemId());
                }
            } else {
                for (MenuItemWrapper<MI> menuItemWrapper : this.menuItems) {
                    Integer menuItemId = menuItemWrapper.getMenuItemId();
                    if (menuItemId != null) {
                        this.menuHelper.removeItem(menu, menuItemId);
                    }
                    if (this.filter.apply(menuItemWrapper.getMenuItem())) continue;
                    this.addMenuItem(activity, menu, menuItemWrapper);
                }
            }
        }
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(@Nonnull Activity activity, @Nonnull MI item) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.onOptionsItemSelected must not be null");
        }
        if (item == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ListActivityMenu.onOptionsItemSelected must not be null");
        }
        if (this.isFromMenuRes()) {
            for (MenuItemWrapper<MI> menuItem : this.menuItems) {
                if (!this.menuHelper.getItemId(item).equals(menuItem.getMenuItemId())) continue;
                menuItem.getMenuItem().onClick(item, (Context)activity);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AMenuItem<MI> findMenuItemById(int menuItemId) {
        for (MenuItemWrapper<MI> menuItem : this.menuItems) {
            if (!Integer.valueOf(menuItemId).equals(menuItem.getMenuItemId())) continue;
            return menuItem.getMenuItem();
        }
        return null;
    }
}

