/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.menu;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.v4.app.FragmentActivity;
import javax.annotation.Nonnull;
import org.solovyev.android.DialogFragmentShower;
import org.solovyev.android.menu.ContextMenu;
import org.solovyev.android.menu.EnumContextMenu;
import org.solovyev.android.menu.LabeledMenuItem;
import org.solovyev.common.BuilderWithData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextMenuBuilder<T extends LabeledMenuItem<D>, D>
implements BuilderWithData<DialogFragmentShower, D> {
    @Nonnull
    private final FragmentActivity fragmentActivity;
    @Nonnull
    private final String fragmentTag;
    @Nonnull
    private final AlertDialog.Builder menuBuilder;
    @Nonnull
    private final ContextMenu<T, D> menu;

    @Nonnull
    public static <T extends Enum, D> ContextMenuBuilder<T, D> newInstance(@Nonnull FragmentActivity fragmentActivity, @Nonnull String fragmentTag, @Nonnull Class<T> enumClass) {
        if (fragmentActivity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ContextMenuBuilder.newInstance must not be null");
        }
        if (fragmentTag == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ContextMenuBuilder.newInstance must not be null");
        }
        if (enumClass == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/ContextMenuBuilder.newInstance must not be null");
        }
        ContextMenuBuilder contextMenuBuilder = new ContextMenuBuilder(fragmentActivity, fragmentTag, EnumContextMenu.newInstance(enumClass));
        if (contextMenuBuilder == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ContextMenuBuilder.newInstance must not return null");
        }
        return contextMenuBuilder;
    }

    @Nonnull
    public static <T extends LabeledMenuItem<D>, D> ContextMenuBuilder<T, D> newInstance(@Nonnull FragmentActivity fragmentActivity, @Nonnull String fragmentTag, @Nonnull ContextMenu<T, D> menu) {
        if (fragmentActivity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ContextMenuBuilder.newInstance must not be null");
        }
        if (fragmentTag == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ContextMenuBuilder.newInstance must not be null");
        }
        if (menu == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/ContextMenuBuilder.newInstance must not be null");
        }
        ContextMenuBuilder<T, D> contextMenuBuilder = new ContextMenuBuilder<T, D>(fragmentActivity, fragmentTag, menu);
        if (contextMenuBuilder == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ContextMenuBuilder.newInstance must not return null");
        }
        return contextMenuBuilder;
    }

    private ContextMenuBuilder(@Nonnull FragmentActivity fragmentActivity, @Nonnull String fragmentTag, @Nonnull ContextMenu<T, D> menu) {
        if (fragmentActivity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ContextMenuBuilder.<init> must not be null");
        }
        if (fragmentTag == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/menu/ContextMenuBuilder.<init> must not be null");
        }
        if (menu == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/menu/ContextMenuBuilder.<init> must not be null");
        }
        this.fragmentActivity = fragmentActivity;
        this.fragmentTag = fragmentTag;
        this.menuBuilder = new AlertDialog.Builder((Context)fragmentActivity);
        this.menu = menu;
    }

    @Nonnull
    public AlertDialog.Builder getMenuBuilder() {
        AlertDialog.Builder builder = this.menuBuilder;
        if (builder == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ContextMenuBuilder.getMenuBuilder must not return null");
        }
        return builder;
    }

    @Nonnull
    public DialogFragmentShower build(final @Nonnull D data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/menu/ContextMenuBuilder.build must not be null");
        }
        this.menuBuilder.setItems(this.menu.getMenuCaptions((Context)this.fragmentActivity), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int item) {
                Object menuItem = ContextMenuBuilder.this.menu.itemAt(item);
                if (menuItem != null) {
                    menuItem.onClick((Object)data, (Context)ContextMenuBuilder.this.fragmentActivity);
                }
            }
        });
        DialogFragmentShower dialogFragmentShower = new DialogFragmentShower(this.fragmentActivity, this.fragmentTag, this.menuBuilder);
        if (dialogFragmentShower == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/menu/ContextMenuBuilder.build must not return null");
        }
        return dialogFragmentShower;
    }
}

