/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.async;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.common.collections.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonAsyncTask<PARAM, PROGRESS, RESULT>
extends AsyncTask<PARAM, PROGRESS, Result<RESULT>> {
    @Nonnull
    private static final String TAG = "CommonAsyncTask";
    @Nonnull
    private final WeakReference<Context> contextRef;

    protected CommonAsyncTask() {
        this.contextRef = new WeakReference<Object>(null);
    }

    protected CommonAsyncTask(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/async/CommonAsyncTask.<init> must not be null");
        }
        this.contextRef = new WeakReference<Context>(context);
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected final Result<RESULT> doInBackground(PARAM ... params) {
        try {
            return new CommonResult<RESULT>(this.doWork(Collections.asList((Object[])params)));
        }
        catch (CommonAsyncTaskRuntimeException e) {
            return new CommonResult(e.getException());
        }
        catch (Exception e) {
            return new CommonResult(e);
        }
    }

    protected abstract RESULT doWork(@Nonnull List<PARAM> var1);

    protected void onPostExecute(@Nonnull Result<RESULT> r) {
        if (r == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/async/CommonAsyncTask.onPostExecute must not be null");
        }
        super.onPostExecute(r);
        if (r.isFailure()) {
            this.onFailurePostExecute(r.getFailureResult());
        } else {
            this.onSuccessPostExecute(r.getSuccessResult());
        }
    }

    @Nullable
    protected Context getContext() {
        return (Context)this.contextRef.get();
    }

    protected abstract void onSuccessPostExecute(@Nullable RESULT var1);

    protected abstract void onFailurePostExecute(@Nonnull Exception var1);

    protected void throwException(@Nonnull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/async/CommonAsyncTask.throwException must not be null");
        }
        throw new CommonAsyncTaskRuntimeException(e);
    }

    protected void defaultOnFailurePostExecute(@Nonnull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/async/CommonAsyncTask.defaultOnFailurePostExecute must not be null");
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
    }

    private static class CommonAsyncTaskRuntimeException
    extends RuntimeException {
        @Nonnull
        private Exception exception;

        public CommonAsyncTaskRuntimeException(@Nonnull Exception exception) {
            if (exception == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/async/CommonAsyncTask$CommonAsyncTaskRuntimeException.<init> must not be null");
            }
            this.exception = exception;
        }

        @Nonnull
        public Exception getException() {
            Exception exception = this.exception;
            if (exception == null) {
                throw new IllegalStateException("@NotNull method org/solovyev/android/async/CommonAsyncTask$CommonAsyncTaskRuntimeException.getException must not return null");
            }
            return exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Result<SR> {
        public boolean isFailure();

        @Nullable
        public Exception getFailureResult();

        @Nullable
        public SR getSuccessResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommonResult<SR>
    implements Result<SR> {
        @Nullable
        private SR successResult;
        @Nullable
        private Exception failureResult;

        public CommonResult(@Nullable SR result) {
            this.successResult = result;
        }

        public CommonResult(@Nonnull Exception e) {
            if (e == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/async/CommonAsyncTask$CommonResult.<init> must not be null");
            }
            this.failureResult = e;
        }

        @Override
        @Nullable
        public SR getSuccessResult() {
            return this.successResult;
        }

        @Override
        @Nullable
        public Exception getFailureResult() {
            return this.failureResult;
        }

        @Override
        public boolean isFailure() {
            return this.failureResult != null;
        }
    }
}

