/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Threads {
    private Threads() {
        throw new AssertionError();
    }

    public static void tryRunOnUiThread(final @Nullable Activity activity, final @Nonnull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Threads.tryRunOnUiThread must not be null");
        }
        if (activity != null && !activity.isFinishing()) {
            if (Threads.isUiThread()) {
                runnable.run();
            } else {
                activity.runOnUiThread(new Runnable(){

                    public void run() {
                        if (!activity.isFinishing()) {
                            runnable.run();
                        }
                    }
                });
            }
        }
    }

    public static void tryRunOnUiThread(final @Nonnull Fragment fragment, final @Nonnull Runnable runnable) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Threads.tryRunOnUiThread must not be null");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Threads.tryRunOnUiThread must not be null");
        }
        Threads.tryRunOnUiThread((Activity)fragment.getActivity(), new Runnable(){

            public void run() {
                FragmentActivity activity = fragment.getActivity();
                if (activity != null) {
                    runnable.run();
                }
            }
        });
    }

    public static boolean isUiThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    @Nonnull
    public static Handler newUiHandler() {
        Handler handler = new Handler(Looper.getMainLooper());
        if (handler == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/Threads.newUiHandler must not return null");
        }
        return handler;
    }
}

