/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Parcelable;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.Activities;
import org.solovyev.android.DeviceModel;
import org.solovyev.android.StringParcelableCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Android {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String TAG = "ACL";
    @Nullable
    private static Boolean debug = null;

    private Android() {
        throw new AssertionError();
    }

    @Nonnull
    public static String newTag(@Nonnull String tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Android.newTag must not be null");
        }
        String string2 = Android.newSubTag(TAG, tag);
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/Android.newTag must not return null");
        }
        return string2;
    }

    @Nonnull
    public static String newSubTag(@Nonnull String tag, @Nonnull String subTag) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Android.newSubTag must not be null");
        }
        if (subTag == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Android.newSubTag must not be null");
        }
        String string2 = tag + "/" + subTag;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/Android.newSubTag must not return null");
        }
        return string2;
    }

    public static int getAppVersionCode(@Nonnull Context context, @Nonnull String appPackageName) throws PackageManager.NameNotFoundException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Android.getAppVersionCode must not be null");
        }
        if (appPackageName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Android.getAppVersionCode must not be null");
        }
        return context.getPackageManager().getPackageInfo((String)appPackageName, (int)0).versionCode;
    }

    public static int getAppVersionCode(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Android.getAppVersionCode must not be null");
        }
        try {
            return Android.getAppVersionCode(context, context.getPackageName());
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean isPhoneModel(@Nonnull DeviceModel phoneModel) {
        if (phoneModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Android.isPhoneModel must not be null");
        }
        String model = Build.MODEL;
        return model != null && phoneModel.getModels().contains(model);
    }

    public static boolean isDebuggable(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Android.isDebuggable must not be null");
        }
        if (debug == null) {
            debug = 0 != (context.getApplicationInfo().flags & 2);
        }
        return debug;
    }

    @Nonnull
    public static Parcelable.Creator<String> getStringParcelableCreator() {
        Parcelable.Creator<String> creator = StringParcelableCreator.getInstance();
        if (creator == null) {
            throw new IllegalStateException("@NotNull method org/solovyev/android/Android.getStringParcelableCreator must not return null");
        }
        return creator;
    }

    @Deprecated
    public static void addIntentFlags(@Nonnull Intent intent, boolean detached, @Nonnull Context context) {
        if (intent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Android.addIntentFlags must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/Android.addIntentFlags must not be null");
        }
        Activities.addIntentFlags(intent, detached, context);
    }

    @Deprecated
    public static void toggleComponent(@Nonnull Context context, @Nonnull Class<?> componentClass, boolean enable) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Android.toggleComponent must not be null");
        }
        if (componentClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Android.toggleComponent must not be null");
        }
        Android.enableComponent(context, componentClass, enable);
    }

    public static void enableComponent(@Nonnull Context context, @Nonnull Class<?> componentClass, boolean enable) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Android.enableComponent must not be null");
        }
        if (componentClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Android.enableComponent must not be null");
        }
        PackageManager pm = context.getPackageManager();
        int componentState = enable ? 1 : 2;
        pm.setComponentEnabledSetting(new ComponentName(context, componentClass), componentState, 1);
    }

    public static boolean isComponentEnabled(@Nonnull Context context, @Nonnull Class<? extends Context> componentClass) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Android.isComponentEnabled must not be null");
        }
        if (componentClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Android.isComponentEnabled must not be null");
        }
        PackageManager pm = context.getPackageManager();
        int componentEnabledSetting = pm.getComponentEnabledSetting(new ComponentName(context, componentClass));
        return componentEnabledSetting == 1 || componentEnabledSetting == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveBitmap(@Nonnull Bitmap bitmap, @Nonnull String path, @Nonnull String fileName) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Android.saveBitmap must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Android.saveBitmap must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/Android.saveBitmap must not be null");
        }
        File filePath = new File(path);
        filePath.mkdirs();
        File file = new File(path, fileName);
        if (!file.exists()) {
            String name = file.getAbsolutePath();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(name);
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
                fos.flush();
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    }
                }
            }
            return name;
        }
        return null;
    }
}

