/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import javax.annotation.Nonnull;
import org.solovyev.android.Android;

public final class Activities {
    private static final String TAG = Android.newTag("Activities");

    private Activities() {
        throw new AssertionError();
    }

    public static void restartActivity(@Nonnull Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Activities.restartActivity must not be null");
        }
        Intent intent = activity.getIntent();
        Log.d((String)TAG, (String)("Restarting activity: " + activity.getClass().getSimpleName()));
        activity.finish();
        activity.startActivity(intent);
    }

    public static void startActivity(@Nonnull Intent intent, @Nonnull Context context) {
        if (intent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Activities.startActivity must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/solovyev/android/Activities.startActivity must not be null");
        }
        Activities.addIntentFlags(intent, false, context);
        context.startActivity(intent);
    }

    public static void addIntentFlags(@Nonnull Intent intent, boolean detached, @Nonnull Context context) {
        if (intent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/solovyev/android/Activities.addIntentFlags must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/solovyev/android/Activities.addIntentFlags must not be null");
        }
        int flags = 0;
        if (!(context instanceof Activity)) {
            flags |= 0x10000000;
        }
        if (detached) {
            flags |= 0x40000000;
        }
        intent.setFlags(flags);
    }
}

