/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.Button;
import java.util.Locale;

public class CapitalizingButton
extends Button {
    private static final boolean SANS_ICE_CREAM = Build.VERSION.SDK_INT < 14;
    private static final boolean IS_GINGERBREAD = Build.VERSION.SDK_INT >= 9;
    private static final int[] R_styleable_Button = new int[]{16842804};
    private static final int R_styleable_Button_textAppearance = 0;
    private static final int[] R_styleable_TextAppearance = new int[]{16843660};
    private static final int R_styleable_TextAppearance_textAllCaps = 0;
    private boolean mAllCaps;

    public CapitalizingButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray appearance;
        TypedArray a = context.obtainStyledAttributes(attrs, R_styleable_Button);
        int ap = a.getResourceId(0, -1);
        a.recycle();
        if (ap != -1 && (appearance = context.obtainStyledAttributes(ap, R_styleable_TextAppearance)) != null) {
            this.mAllCaps = appearance.getBoolean(0, true);
            appearance.recycle();
        }
    }

    public void setTextCompat(CharSequence text) {
        if (SANS_ICE_CREAM && this.mAllCaps && text != null) {
            if (IS_GINGERBREAD) {
                try {
                    this.setText(text.toString().toUpperCase(Locale.ROOT));
                }
                catch (NoSuchFieldError e) {
                    this.setText(text.toString().toUpperCase());
                }
            } else {
                this.setText(text.toString().toUpperCase());
            }
        } else {
            this.setText(text);
        }
    }
}

