/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.internal.ActionBarSherlockCompat;
import com.actionbarsherlock.internal.ActionBarSherlockNative;
import com.actionbarsherlock.view.ActionMode;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuInflater;
import com.actionbarsherlock.view.MenuItem;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActionBarSherlock {
    protected static final String TAG = "ActionBarSherlock";
    public static final boolean DEBUG = false;
    private static final Class<?>[] CONSTRUCTOR_ARGS = new Class[]{Activity.class, Integer.TYPE};
    private static final HashMap<Implementation, Class<? extends ActionBarSherlock>> IMPLEMENTATIONS = new HashMap();
    public static final int FLAG_DELEGATE = 1;
    protected final Activity mActivity;
    protected final boolean mIsDelegate;
    protected MenuInflater mMenuInflater;

    public static void registerImplementation(Class<? extends ActionBarSherlock> implementationClass) {
        if (!implementationClass.isAnnotationPresent(Implementation.class)) {
            throw new IllegalArgumentException("Class " + implementationClass.getSimpleName() + " is not annotated with @Implementation");
        }
        if (IMPLEMENTATIONS.containsValue(implementationClass)) {
            return;
        }
        Implementation impl = implementationClass.getAnnotation(Implementation.class);
        IMPLEMENTATIONS.put(impl, implementationClass);
    }

    public static boolean unregisterImplementation(Class<? extends ActionBarSherlock> implementationClass) {
        return IMPLEMENTATIONS.values().remove(implementationClass);
    }

    public static ActionBarSherlock wrap(Activity activity) {
        return ActionBarSherlock.wrap(activity, 0);
    }

    public static ActionBarSherlock wrap(Activity activity, int flags) {
        HashMap<Implementation, Class<? extends ActionBarSherlock>> impls = new HashMap<Implementation, Class<? extends ActionBarSherlock>>(IMPLEMENTATIONS);
        boolean hasQualfier = false;
        for (Implementation key : impls.keySet()) {
            if (key.dpi() != 213) continue;
            hasQualfier = true;
            break;
        }
        if (hasQualfier) {
            boolean isTvDpi = activity.getResources().getDisplayMetrics().densityDpi == 213;
            Iterator<Implementation> keys = impls.keySet().iterator();
            while (keys.hasNext()) {
                int keyDpi = keys.next().dpi();
                if ((!isTvDpi || keyDpi == 213) && (isTvDpi || keyDpi != 213)) continue;
                keys.remove();
            }
        }
        hasQualfier = false;
        for (Implementation key : impls.keySet()) {
            if (key.api() == -1) continue;
            hasQualfier = true;
            break;
        }
        if (hasQualfier) {
            int runtimeApi = Build.VERSION.SDK_INT;
            int bestApi = 0;
            Iterator<Implementation> keys = impls.keySet().iterator();
            while (keys.hasNext()) {
                int keyApi = keys.next().api();
                if (keyApi > runtimeApi) {
                    keys.remove();
                    continue;
                }
                if (keyApi <= bestApi) continue;
                bestApi = keyApi;
            }
            keys = impls.keySet().iterator();
            while (keys.hasNext()) {
                if (keys.next().api() == bestApi) continue;
                keys.remove();
            }
        }
        if (impls.size() > 1) {
            throw new IllegalStateException("More than one implementation matches configuration.");
        }
        if (impls.isEmpty()) {
            throw new IllegalStateException("No implementations match configuration.");
        }
        Class<? extends ActionBarSherlock> impl = impls.values().iterator().next();
        try {
            Constructor<? extends ActionBarSherlock> ctor = impl.getConstructor(CONSTRUCTOR_ARGS);
            return ctor.newInstance(activity, flags);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected ActionBarSherlock(Activity activity, int flags) {
        this.mActivity = activity;
        this.mIsDelegate = (flags & 1) != 0;
    }

    public abstract ActionBar getActionBar();

    public void dispatchConfigurationChanged(Configuration newConfig) {
    }

    public void dispatchPostResume() {
    }

    public void dispatchPause() {
    }

    public void dispatchStop() {
    }

    public abstract void dispatchInvalidateOptionsMenu();

    public boolean dispatchOpenOptionsMenu() {
        return false;
    }

    public boolean dispatchCloseOptionsMenu() {
        return false;
    }

    public void dispatchPostCreate(Bundle savedInstanceState) {
    }

    public void dispatchTitleChanged(CharSequence title, int color2) {
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return false;
    }

    public abstract boolean dispatchCreateOptionsMenu(android.view.Menu var1);

    public abstract boolean dispatchPrepareOptionsMenu(android.view.Menu var1);

    public abstract boolean dispatchOptionsItemSelected(android.view.MenuItem var1);

    public boolean dispatchMenuOpened(int featureId, android.view.Menu menu) {
        return false;
    }

    public void dispatchPanelClosed(int featureId, android.view.Menu menu) {
    }

    public void dispatchDestroy() {
    }

    public void dispatchSaveInstanceState(Bundle outState) {
    }

    public void dispatchRestoreInstanceState(Bundle savedInstanceState) {
    }

    protected final boolean callbackCreateOptionsMenu(Menu menu) {
        boolean result = true;
        if (this.mActivity instanceof OnCreatePanelMenuListener) {
            OnCreatePanelMenuListener listener = (OnCreatePanelMenuListener)this.mActivity;
            result = listener.onCreatePanelMenu(0, menu);
        } else if (this.mActivity instanceof OnCreateOptionsMenuListener) {
            OnCreateOptionsMenuListener listener = (OnCreateOptionsMenuListener)this.mActivity;
            result = listener.onCreateOptionsMenu(menu);
        }
        return result;
    }

    protected final boolean callbackPrepareOptionsMenu(Menu menu) {
        boolean result = true;
        if (this.mActivity instanceof OnPreparePanelListener) {
            OnPreparePanelListener listener = (OnPreparePanelListener)this.mActivity;
            result = listener.onPreparePanel(0, null, menu);
        } else if (this.mActivity instanceof OnPrepareOptionsMenuListener) {
            OnPrepareOptionsMenuListener listener = (OnPrepareOptionsMenuListener)this.mActivity;
            result = listener.onPrepareOptionsMenu(menu);
        }
        return result;
    }

    protected final boolean callbackOptionsItemSelected(MenuItem item) {
        boolean result = false;
        if (this.mActivity instanceof OnMenuItemSelectedListener) {
            OnMenuItemSelectedListener listener = (OnMenuItemSelectedListener)this.mActivity;
            result = listener.onMenuItemSelected(0, item);
        } else if (this.mActivity instanceof OnOptionsItemSelectedListener) {
            OnOptionsItemSelectedListener listener = (OnOptionsItemSelectedListener)this.mActivity;
            result = listener.onOptionsItemSelected(item);
        }
        return result;
    }

    public abstract boolean hasFeature(int var1);

    public abstract boolean requestFeature(int var1);

    public abstract void setUiOptions(int var1);

    public abstract void setUiOptions(int var1, int var2);

    public abstract void setContentView(int var1);

    public void setContentView(View view) {
        this.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    public abstract void setContentView(View var1, ViewGroup.LayoutParams var2);

    public abstract void addContentView(View var1, ViewGroup.LayoutParams var2);

    public abstract void setTitle(CharSequence var1);

    public void setTitle(int resId) {
        this.setTitle(this.mActivity.getString(resId));
    }

    public abstract void setProgressBarVisibility(boolean var1);

    public abstract void setProgressBarIndeterminateVisibility(boolean var1);

    public abstract void setProgressBarIndeterminate(boolean var1);

    public abstract void setProgress(int var1);

    public abstract void setSecondaryProgress(int var1);

    public MenuInflater getMenuInflater() {
        if (this.mMenuInflater == null) {
            this.mMenuInflater = this.getActionBar() != null ? new MenuInflater(this.getThemedContext(), this.mActivity) : new MenuInflater((Context)this.mActivity);
        }
        return this.mMenuInflater;
    }

    protected abstract Context getThemedContext();

    public abstract ActionMode startActionMode(ActionMode.Callback var1);

    public void ensureActionBar() {
    }

    static {
        ActionBarSherlock.registerImplementation(ActionBarSherlockCompat.class);
        ActionBarSherlock.registerImplementation(ActionBarSherlockNative.class);
    }

    public static interface OnActionModeStartedListener {
        public void onActionModeStarted(ActionMode var1);
    }

    public static interface OnActionModeFinishedListener {
        public void onActionModeFinished(ActionMode var1);
    }

    public static interface OnPrepareOptionsMenuListener {
        public boolean onPrepareOptionsMenu(Menu var1);
    }

    public static interface OnPreparePanelListener {
        public boolean onPreparePanel(int var1, View var2, Menu var3);
    }

    public static interface OnOptionsItemSelectedListener {
        public boolean onOptionsItemSelected(MenuItem var1);
    }

    public static interface OnMenuItemSelectedListener {
        public boolean onMenuItemSelected(int var1, MenuItem var2);
    }

    public static interface OnCreateOptionsMenuListener {
        public boolean onCreateOptionsMenu(Menu var1);
    }

    public static interface OnCreatePanelMenuListener {
        public boolean onCreatePanelMenu(int var1, Menu var2);
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Implementation {
        public static final int DEFAULT_API = -1;
        public static final int DEFAULT_DPI = -1;

        public int api() default -1;

        public int dpi() default -1;
    }
}

