/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master.test;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import jetbrains.exodus.env.Environments;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.agentx.master.AgentXMasterAgent;
import org.snmp4j.agent.db.MOXodusPersistence;
import org.snmp4j.agent.db.MOXodusPersistenceProvider;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.cfg.EngineBootsProvider;
import org.snmp4j.log.ConsoleLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class TestMasterAgent {
    public static LogAdapter logger;
    protected String address;
    protected AgentXMasterAgent agent;
    protected MOServer server;
    private MOXodusPersistence moXodusPersistence;

    public TestMasterAgent(Map<String, List<Object>> args) {
        String configFile = (String)args.get("c").get(0);
        this.server = new DefaultMOServer();
        MOServer[] moServers = new MOServer[]{this.server};
        this.moXodusPersistence = new MOXodusPersistence(moServers, Environments.newInstance((String)configFile));
        MOXodusPersistenceProvider moXodusPersistenceProvider = new MOXodusPersistenceProvider(this.moXodusPersistence);
        OctetString defaultEngineID = new OctetString(MPv3.createLocalEngineID());
        MessageDispatcherImpl messageDispatcher = new MessageDispatcherImpl();
        this.addListenAddresses((MessageDispatcher)messageDispatcher, args.get("address"));
        this.agent = new AgentXMasterAgent(moXodusPersistenceProvider.getEngineId(defaultEngineID), (MessageDispatcher)messageDispatcher, null, moServers, (WorkerPool)ThreadPool.create((String)"SampleAgentXMaster", (int)3), null, (MOPersistenceProvider)moXodusPersistenceProvider, (EngineBootsProvider)moXodusPersistenceProvider){

            public void configure() {
                if (!TestMasterAgent.this.moXodusPersistence.isContextLoadable(null)) {
                    TestMasterAgent.this.moXodusPersistence.setIgnoreChangeListenerEvents(true);
                    super.configure();
                    TestMasterAgent.this.addCommunities(this.communityMIB);
                    TestMasterAgent.this.addUsmUser(this.usm);
                    TestMasterAgent.this.addNotificationTargets(this.targetMIB, this.notificationMIB);
                    TestMasterAgent.this.addViews(this.vacmMIB);
                    TestMasterAgent.this.moXodusPersistence.save();
                }
            }
        };
        this.agent.addAgentStateListener((agentConfigManager, agentState) -> {
            switch (agentState.getState()) {
                case 10: {
                    this.moXodusPersistence.registerChangeListenersWithServer(this.server);
                    break;
                }
                case -1: {
                    this.moXodusPersistence.unregisterChangeListenersWithServer(this.server);
                }
            }
        });
    }

    protected void addListenAddresses(MessageDispatcher md, List<Object> addresses) {
        for (Object addr : addresses) {
            if (addr == null) continue;
            Address address = GenericAddress.parse((String)addr.toString());
            TransportMapping tm = TransportMappings.getInstance().createTransportMapping(address);
            if (tm != null) {
                try {
                    tm.listen();
                    md.addTransportMapping(tm);
                }
                catch (IOException e) {
                    logger.error((Serializable)((Object)("IO exception while listening on address '" + address + "', transport mapping disabled.")));
                }
                continue;
            }
            logger.warn((Serializable)((Object)("No transport mapping available for address '" + address + "'.")));
        }
    }

    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
        targetMIB.addDefaultTDomains();
        targetMIB.addTargetAddress(new OctetString("notification"), TransportDomains.transportDomainUdpIpv4, new OctetString(new UdpAddress("127.0.0.1/162").getValue()), 200, 1, new OctetString("notify"), new OctetString("v2c"), 4);
        targetMIB.addTargetParams(new OctetString("v2c"), 1, 2, new OctetString("public"), 1, 4);
        notificationMIB.addNotifyEntry(new OctetString("default"), new OctetString("notify"), 1, 4);
    }

    protected void addViews(VacmMIB vacm) {
        vacm.addGroup(1, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addGroup(2, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addGroup(3, new OctetString("SHADES"), new OctetString("v3group"), 3);
        vacm.addGroup(3, new OctetString("TEST"), new OctetString("v3test"), 3);
        vacm.addGroup(3, new OctetString("SHA"), new OctetString("v3restricted"), 3);
        vacm.addAccess(new OctetString("v1v2group"), new OctetString(), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3group"), new OctetString(), 3, 3, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3restricted"), new OctetString(), 3, 2, 1, new OctetString("restrictedReadView"), new OctetString("restrictedWriteView"), new OctetString("restrictedNotifyView"), 3);
        vacm.addAccess(new OctetString("v3test"), new OctetString(), 3, 3, 1, new OctetString("testReadView"), new OctetString("testWriteView"), new OctetString("testNotifyView"), 3);
        vacm.addViewTreeFamily(new OctetString("fullReadView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullWriteView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullNotifyView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2.1.1"), new OctetString(), 2, 3);
        vacm.addViewTreeFamily(new OctetString("testWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
    }

    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        Variable[] com2sec = new Variable[]{new OctetString("public"), new OctetString("public"), this.agent.getLocalEngineID(), new OctetString(), new OctetString(), new Integer32(3), new Integer32(1)};
        SnmpCommunityMIB.SnmpCommunityEntryRow row = (SnmpCommunityMIB.SnmpCommunityEntryRow)communityMIB.getSnmpCommunityEntry().createRow(new OctetString("public2public").toSubIndex(true), com2sec);
        communityMIB.getSnmpCommunityEntry().addRow((MOTableRow)row);
    }

    protected void addUsmUser(USM usm) {
        UsmUser user = new UsmUser(new OctetString("SHADES"), AuthSHA.ID, new OctetString("SHADESAuthPassword"), PrivDES.ID, new OctetString("SHADESPrivPassword"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("TEST"), AuthSHA.ID, new OctetString("maplesyrup"), PrivDES.ID, new OctetString("maplesyrup"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("SHA"), AuthSHA.ID, new OctetString("SHAAuthPassword"), null, null);
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
    }

    public static void main(String[] args) {
        ArgumentParser parser = new ArgumentParser("-c[s{=SampleAgent.cfg}] -X[s{=tcp:0.0.0.0/705}<tcp:.*[/[0-9]+]?>] +h +v", "#address[s<(udp|tcp):.*[/[0-9]+]?>] ..");
        Map commandLineParameters = null;
        try {
            commandLineParameters = parser.parse(args);
            if (commandLineParameters.containsKey("h")) {
                TestMasterAgent.printUsage();
                System.exit(0);
            }
            if (commandLineParameters.containsKey("v")) {
                System.out.println("Options: " + commandLineParameters);
            }
            TestMasterAgent sampleAgent = new TestMasterAgent(commandLineParameters);
            String agentXAddress = ((String)((List)commandLineParameters.get("X")).get(0)).substring(4);
            sampleAgent.agent.addAgentXTransportMapping((TransportMapping<?>)new DefaultTcpTransportMapping(new TcpAddress(agentXAddress)));
            sampleAgent.agent.registerShutdownHook();
            sampleAgent.agent.run();
            sampleAgent.agent.getCommandProcessor().setAcceptNewContexts(true);
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ex1) {
            }
        }
        catch (ArgumentParser.ArgumentParseException ax) {
            TestMasterAgent.printUsage();
            System.out.println(ax.getMessage());
        }
        catch (Exception ex) {
            logger.fatal((CharSequence)"Caught exception while starting the agent", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    private static void printUsage() {
        String[] txt;
        for (String line : txt = new String[]{"Usage: TestMasterAgent [-c <config-path>] [-h] [-v]", "                       [-X <masterAddress>] <address1> [<address2> ..]", "", "where ", "  <config-path>        is the directory where persistent MIB data is stored/read.", "  -h                   prints this usage help information and exit.", "  -v                   print command line parameters.", "  <masterAddress>      is the TCP AgentX master agent address of the local", "                       host following the format 'tcp:<host>/<port>'.", "  <address>            a listen address following the format ", "                       'udp|tcp:<host>/<port>', for example udp:0.0.0.0/161", ""}) {
            System.out.println(line);
        }
    }

    static {
        LogFactory.setLogFactory((LogFactory)new ConsoleLogFactory());
        LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.ALL);
        logger = LogFactory.getLogger(TestMasterAgent.class);
    }
}

