/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master;

import org.snmp4j.agent.agentx.AgentXRegion;
import org.snmp4j.agent.agentx.master.AgentXMasterSession;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class AgentXRegEntry<A extends Address>
implements Comparable<AgentXRegEntry<A>> {
    private AgentXMasterSession<A> session;
    private AgentXRegion region;
    private int priority;
    private OctetString context;
    private int timeout;
    private OID id;

    public AgentXRegEntry(AgentXMasterSession<A> session, AgentXRegion region, int priority, OctetString context, int timeout) {
        this.session = session;
        this.region = region;
        this.priority = priority;
        this.context = context;
        if (this.context == null) {
            this.context = new OctetString();
        }
        this.timeout = timeout;
    }

    public OctetString getContext() {
        return this.context;
    }

    public int getPriority() {
        return this.priority;
    }

    public AgentXRegion getRegion() {
        return this.region;
    }

    public AgentXMasterSession<A> getSession() {
        return this.session;
    }

    public int getSpecific() {
        return this.region.getLowerBound().size();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public OID getId() {
        return this.id;
    }

    @Override
    public int compareTo(AgentXRegEntry<A> other) {
        int diff = other.getSpecific() - this.getSpecific();
        if (diff == 0) {
            diff = this.getPriority() - other.getPriority();
        }
        return diff;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AgentXRegEntry) {
            AgentXRegEntry other = (AgentXRegEntry)obj;
            return this.session.equals(other.session) && this.region.equals(other.region) && this.compareTo(other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.session.getSessionID() + this.region.getLowerBound().hashCode();
    }

    public void setId(OID id) {
        this.id = id;
    }

    public String toString() {
        return this.getClass().getName() + "[region=" + this.region + ",priority=" + this.priority + ",context=" + this.context + ",timeout=" + this.timeout + ",id=" + this.id + ",session=" + this.session + "]";
    }
}

